/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.graylog2.ServerVersion;
import org.graylog2.configuration.VersionCheckConfiguration;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Version;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.versioncheck.VersionCheckResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionCheckThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(VersionCheckThread.class);
    private final NotificationService notificationService;
    private final ServerStatus serverStatus;
    private final VersionCheckConfiguration versionCheckConfiguration;
    private final URI httpProxyUri;

    @Inject
    public VersionCheckThread(NotificationService notificationService, ServerStatus serverStatus, VersionCheckConfiguration versionCheckConfiguration, @Named(value="http_proxy_uri") @Nullable URI httpProxyUri) {
        this.notificationService = notificationService;
        this.serverStatus = serverStatus;
        this.versionCheckConfiguration = versionCheckConfiguration;
        this.httpProxyUri = httpProxyUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        HttpGet get;
        try {
            URIBuilder uri = new URIBuilder(this.versionCheckConfiguration.getUri());
            uri.addParameter("anonid", this.serverStatus.getNodeId().anonymize());
            uri.addParameter("version", ServerVersion.VERSION.toString());
            get = new HttpGet(uri.build());
            get.setHeader("User-Agent", "graylog2-server (" + System.getProperty("java.vendor") + ", " + System.getProperty("java.version") + ", " + System.getProperty("os.name") + ", " + System.getProperty("os.version") + ")");
            RequestConfig.Builder configBuilder = RequestConfig.custom().setConnectTimeout(this.versionCheckConfiguration.getConnectTimeOut()).setSocketTimeout(this.versionCheckConfiguration.getSocketTimeOut()).setConnectionRequestTimeout(this.versionCheckConfiguration.getConnectionRequestTimeOut());
            if (this.httpProxyUri != null) {
                try {
                    configBuilder.setProxy(new HttpHost(this.httpProxyUri.getHost(), this.httpProxyUri.getPort(), this.httpProxyUri.getScheme()));
                }
                catch (Exception e) {
                    LOG.error("Invalid version check proxy URI: " + this.httpProxyUri, (Throwable)e);
                    return;
                }
            }
            get.setConfig(configBuilder.build());
        }
        catch (URISyntaxException e) {
            LOG.error("Invalid version check URI.", (Throwable)e);
            return;
        }
        CloseableHttpClient http = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            response = http.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                LOG.error("Expected version check HTTP status code [200] but got [{}]", (Object)response.getStatusLine().getStatusCode());
                return;
            }
            HttpEntity entity = response.getEntity();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)entity.getContent(), (Writer)writer, (Charset)Charset.forName("UTF-8"));
            String body = writer.toString();
            VersionCheckResponse parsedResponse = this.parse(body);
            Version reportedVersion = new Version(parsedResponse.version.major, parsedResponse.version.minor, parsedResponse.version.patch);
            LOG.debug("Version check reports current version: " + parsedResponse);
            if (reportedVersion.greaterMinor(ServerVersion.VERSION)) {
                LOG.debug("Reported version is higher than ours ({}). Writing notification.", (Object)ServerVersion.VERSION);
                Notification notification = this.notificationService.buildNow().addSeverity(Notification.Severity.NORMAL).addType(Notification.Type.OUTDATED_VERSION).addDetail("current_version", parsedResponse.toString());
                this.notificationService.publishIfFirst(notification);
            } else {
                LOG.debug("Reported version is not higher than ours ({}).", (Object)ServerVersion.VERSION);
                this.notificationService.fixed(Notification.Type.OUTDATED_VERSION);
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            LOG.warn("Could not perform version check.", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Could not close HTTP connection to version check API.", (Throwable)e);
            }
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    private VersionCheckResponse parse(String httpBody) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (VersionCheckResponse)mapper.readValue(httpBody, VersionCheckResponse.class);
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return true;
    }

    public boolean startOnThisNode() {
        return this.versionCheckConfiguration.isEnabled() && !this.serverStatus.hasCapability(ServerStatus.Capability.LOCALMODE);
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 0;
    }

    public int getPeriodSeconds() {
        return (int)TimeUnit.MINUTES.toSeconds(30L);
    }
}

