/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Date;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAccessLogFilter
implements ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.graylog2.rest.accesslog");

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        try {
            InetSocketAddress remoteAddr = (InetSocketAddress)requestContext.getProperty("org.graylog2.jersey.container.netty.request.property.remote_addr");
            String rawQuery = requestContext.getUriInfo().getRequestUri().getRawQuery();
            String remoteUser = ((ShiroSecurityContext)requestContext.getSecurityContext()).getUsername();
            Date requestDate = requestContext.getDate();
            LOG.debug("{} {} [{}] \"{} {}{}\" {} {} {}", new Object[]{remoteAddr.getAddress().getHostAddress(), remoteUser == null ? "-" : remoteUser, requestDate == null ? "-" : requestDate, requestContext.getMethod(), requestContext.getUriInfo().getPath(), rawQuery == null ? "" : "?" + rawQuery, requestContext.getHeaderString("User-Agent"), responseContext.getStatus(), responseContext.getLength()});
        }
        catch (Exception ignored) {
            LOG.error(":(", (Throwable)ignored);
        }
    }
}

