/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.alarmcallbacks;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alarmcallbacks.CreateAlarmCallbackRequest;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="AlarmCallbacks", description="Manage stream alarm callbacks")
@Path(value="/streams/{streamid}/alarmcallbacks")
public class AlarmCallbackResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmCallbackResource.class);
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;
    private final StreamService streamService;
    private final Set<AlarmCallback> availableAlarmCallbacks;

    @Inject
    public AlarmCallbackResource(AlarmCallbackConfigurationService alarmCallbackConfigurationService, StreamService streamService, Set<AlarmCallback> availableAlarmCallbacks) {
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
        this.streamService = streamService;
        this.availableAlarmCallbacks = availableAlarmCallbacks;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all alarm callbacks for this stream")
    @Produces(value={"application/json"})
    public Map<String, Object> get(@ApiParam(name="streamid", value="The id of the stream whose alarm callbacks we want.", required=true) @PathParam(value="streamid") String streamid) throws NotFoundException {
        Stream stream = this.streamService.load(streamid);
        ArrayList alarmCallbacks = Lists.newArrayList();
        for (AlarmCallbackConfiguration callback : this.alarmCallbackConfigurationService.getForStream(stream)) {
            alarmCallbacks.add(callback.getFields());
        }
        return ImmutableMap.of((Object)"alarmcallbacks", (Object)alarmCallbacks, (Object)"total", (Object)alarmCallbacks.size());
    }

    @GET
    @Path(value="/{alarmCallbackId}")
    @Timed
    @ApiOperation(value="Get a single specified alarm callback for this stream")
    @Produces(value={"application/json"})
    public Map<String, Object> get(@ApiParam(name="streamid", value="The id of the stream whose alarm callbacks we want.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="alarmCallbackId", value="The alarm callback id we are getting", required=true) @PathParam(value="alarmCallbackId") String alarmCallbackId) throws NotFoundException {
        Stream stream = this.streamService.load(streamid);
        AlarmCallbackConfiguration result = this.alarmCallbackConfigurationService.load(alarmCallbackId);
        if (result == null || !result.getStreamId().equals(stream.getId())) {
            throw new javax.ws.rs.NotFoundException();
        }
        return result.getFields();
    }

    @POST
    @Timed
    @ApiOperation(value="Create an alarm callback")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@ApiParam(name="streamid", value="The stream id this new alarm callback belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="JSON body", required=true) CreateAlarmCallbackRequest cr) throws NotFoundException {
        String id;
        this.checkPermission("streams:edit", streamid);
        Stream stream = this.streamService.load(streamid);
        AlarmCallbackConfiguration alarmCallbackConfiguration = this.alarmCallbackConfigurationService.create(streamid, cr, this.getCurrentUser().getName());
        alarmCallbackConfiguration.setStream(stream);
        try {
            id = this.alarmCallbackConfigurationService.save(alarmCallbackConfiguration);
        }
        catch (ValidationException e) {
            LOG.error("Validation error.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        ImmutableMap result = ImmutableMap.of((Object)"alarmcallback_id", (Object)id);
        URI alarmCallbackUri = this.getUriBuilderToSelf().path(AlarmCallbackResource.class).path("{alarmCallbackId}").build(new Object[]{streamid, id});
        return Response.created((URI)alarmCallbackUri).entity((Object)result).build();
    }

    @GET
    @Path(value="/available")
    @Timed
    @ApiOperation(value="Get a list of all alarm callback types")
    @Produces(value={"application/json"})
    public Map<String, Map<String, Object>> available(@ApiParam(name="streamid", value="The id of the stream whose alarm callbacks we want.", required=true) @PathParam(value="streamid") String streamid) {
        HashMap types = Maps.newHashMapWithExpectedSize((int)this.availableAlarmCallbacks.size());
        for (AlarmCallback availableAlarmCallback : this.availableAlarmCallbacks) {
            HashMap type = Maps.newHashMap();
            type.put("requested_configuration", availableAlarmCallback.getRequestedConfiguration().asList());
            type.put("name", availableAlarmCallback.getName());
            types.put(availableAlarmCallback.getClass().getCanonicalName(), type);
        }
        return ImmutableMap.of((Object)"types", (Object)types);
    }

    @DELETE
    @Path(value="/{alarmCallbackId}")
    @Timed
    @ApiOperation(value="Delete an alarm callback")
    @ApiResponses(value={@ApiResponse(code=404, message="Alarm callback not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public void delete(@ApiParam(name="streamid", value="The stream id this new rule belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="alarmCallbackId", required=true) @PathParam(value="alarmCallbackId") String alarmCallbackId) throws NotFoundException {
        Stream stream = this.streamService.load(streamid);
        AlarmCallbackConfiguration result = this.alarmCallbackConfigurationService.load(alarmCallbackId);
        if (result == null || !result.getStreamId().equals(stream.getId())) {
            throw new javax.ws.rs.NotFoundException();
        }
        if (this.alarmCallbackConfigurationService.destroy(result) == 0) {
            LOG.error("Couldn't remove alarm callback with id {}", (Object)result.getId());
            throw new InternalServerErrorException();
        }
    }
}

