/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.dashboards;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.dashboards.Dashboard;
import org.graylog2.dashboards.DashboardImpl;
import org.graylog2.dashboards.DashboardRegistry;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.rest.resources.dashboards.requests.AddWidgetRequest;
import org.graylog2.rest.resources.dashboards.requests.CreateDashboardRequest;
import org.graylog2.rest.resources.dashboards.requests.UpdateDashboardRequest;
import org.graylog2.rest.resources.dashboards.requests.UpdateWidgetRequest;
import org.graylog2.rest.resources.dashboards.requests.WidgetPositions;
import org.graylog2.rest.resources.dashboards.responses.DashboardList;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Dashboards", description="Manage dashboards")
@Path(value="/dashboards")
public class DashboardsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardsResource.class);
    private DashboardService dashboardService;
    private DashboardRegistry dashboardRegistry;
    private ActivityWriter activityWriter;
    private MetricRegistry metricRegistry;
    private final Searches searches;

    @Inject
    public DashboardsResource(DashboardService dashboardService, DashboardRegistry dashboardRegistry, ActivityWriter activityWriter, MetricRegistry metricRegistry, Searches searches) {
        this.dashboardService = dashboardService;
        this.dashboardRegistry = dashboardRegistry;
        this.activityWriter = activityWriter;
        this.metricRegistry = metricRegistry;
        this.searches = searches;
    }

    @POST
    @Timed
    @ApiOperation(value="Create a dashboard")
    @RequiresPermissions(value={"dashboards:create"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="Request must be performed against master node.")})
    public Response create(@ApiParam(name="JSON body", required=true) CreateDashboardRequest cr) throws ValidationException {
        this.restrictToMaster();
        HashMap dashboardData = Maps.newHashMap();
        dashboardData.put("title", cr.title());
        dashboardData.put("description", cr.description());
        dashboardData.put("creator_user_id", this.getCurrentUser().getName());
        dashboardData.put("created_at", Tools.iso8601());
        DashboardImpl dashboard = new DashboardImpl(dashboardData);
        String id = this.dashboardService.save(dashboard);
        this.dashboardRegistry.add(dashboard);
        ImmutableMap result = ImmutableMap.of((Object)"dashboard_id", (Object)id);
        URI dashboardUri = this.getUriBuilderToSelf().path(DashboardsResource.class).path("{dashboardId}").build(new Object[]{id});
        return Response.created((URI)dashboardUri).entity((Object)result).build();
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all dashboards and all configurations of their widgets.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="Request must be performed against master node.")})
    public DashboardList list() {
        this.restrictToMaster();
        ArrayList dashboards = Lists.newArrayList();
        for (Dashboard dashboard : this.dashboardService.all()) {
            if (!this.isPermitted("dashboards:read", dashboard.getId())) continue;
            dashboards.add(dashboard.asMap());
        }
        return DashboardList.create(dashboards.size(), dashboards);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a single dashboards and all configurations of its widgets.")
    @Path(value="/{dashboardId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=403, message="Request must be performed against master node.")})
    @Produces(value={"application/json"})
    public Map<String, Object> get(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId) throws org.graylog2.database.NotFoundException {
        this.restrictToMaster();
        this.checkPermission("dashboards:read", dashboardId);
        return this.dashboardService.load(dashboardId).asMap();
    }

    @DELETE
    @Timed
    @ApiOperation(value="Delete a dashboard and all its widgets")
    @Produces(value={"application/json"})
    @Path(value="/{dashboardId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=403, message="Request must be performed against master node.")})
    public void delete(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId) throws org.graylog2.database.NotFoundException {
        this.restrictToMaster();
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        this.dashboardRegistry.remove(dashboardId);
        this.dashboardService.destroy(dashboard);
        String msg = "Deleted dashboard <" + dashboard.getId() + ">. Reason: REST request.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, DashboardsResource.class));
    }

    @PUT
    @Timed
    @ApiOperation(value="Update the settings of a dashboard.")
    @Produces(value={"application/json"})
    @Path(value="/{dashboardId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found.")})
    public void update(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="JSON body", required=true) UpdateDashboardRequest cr) throws ValidationException, org.graylog2.database.NotFoundException {
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        if (cr.title() != null) {
            dashboard.setTitle(cr.title());
        }
        if (cr.description() != null) {
            dashboard.setDescription(cr.description());
        }
        this.dashboardService.save(dashboard);
    }

    @PUT
    @Timed
    @ApiOperation(value="Update/set the positions of dashboard widgets.")
    @Produces(value={"application/json"})
    @Path(value="/{dashboardId}/positions")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found.")})
    public void setPositions(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="JSON body", required=true) @Valid WidgetPositions uwpr) throws org.graylog2.database.NotFoundException, ValidationException {
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        this.dashboardService.updateWidgetPositions(dashboard, uwpr);
    }

    @POST
    @Timed
    @ApiOperation(value="Add a widget to a dashboard")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=400, message="Validation error."), @ApiResponse(code=400, message="No such widget type."), @ApiResponse(code=403, message="Request must be performed against master node.")})
    @Path(value="/{dashboardId}/widgets")
    public Response addWidget(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="JSON body", required=true) AddWidgetRequest awr) throws ValidationException {
        DashboardWidget widget;
        this.restrictToMaster();
        this.checkPermission("dashboards:edit", dashboardId);
        if (awr.config().containsKey("stream_id")) {
            this.checkPermission("streams:read", (String)awr.config().get("stream_id"));
        } else {
            this.checkPermission("searches:absolute");
            this.checkPermission("searches:relative");
            this.checkPermission("searches:keyword");
        }
        try {
            widget = DashboardWidget.fromRequest(this.metricRegistry, this.searches, awr, this.getCurrentUser().getName());
            Dashboard dashboard = this.dashboardRegistry.get(dashboardId);
            if (dashboard == null) {
                LOG.error("Dashboard [{}] not found.", (Object)dashboardId);
                throw new WebApplicationException(404);
            }
            this.dashboardService.addWidget(dashboard, widget);
        }
        catch (DashboardWidget.NoSuchWidgetTypeException e2) {
            LOG.error("No such widget type.", (Throwable)e2);
            throw new BadRequestException((Throwable)e2);
        }
        catch (InvalidRangeParametersException e3) {
            LOG.error("Invalid timerange parameters provided.", (Throwable)e3);
            throw new BadRequestException((Throwable)e3);
        }
        catch (InvalidWidgetConfigurationException e4) {
            LOG.error("Invalid widget configuration.", (Throwable)e4);
            throw new BadRequestException((Throwable)e4);
        }
        ImmutableMap result = ImmutableMap.of((Object)"widget_id", (Object)widget.getId());
        URI widgetUri = this.getUriBuilderToSelf().path(DashboardsResource.class).path("{dashboardId}/widgets/{widgetId}").build(new Object[]{dashboardId, widget.getId()});
        return Response.created((URI)widgetUri).entity((Object)result).build();
    }

    @DELETE
    @Timed
    @ApiOperation(value="Delete a widget")
    @Path(value="/{dashboardId}/widgets/{widgetId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found."), @ApiResponse(code=403, message="Request must be performed against master node.")})
    @Produces(value={"application/json"})
    public void remove(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId) {
        this.restrictToMaster();
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardRegistry.get(dashboardId);
        if (dashboard == null) {
            LOG.error("Dashboard not found.");
            throw new NotFoundException();
        }
        DashboardWidget widget = dashboard.getWidget(widgetId);
        this.dashboardService.removeWidget(dashboard, widget);
        String msg = "Deleted widget <" + widgetId + "> from dashboard <" + dashboardId + ">. Reason: REST request.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, DashboardsResource.class));
    }

    @GET
    @Timed
    @ApiOperation(value="Get a single widget value.")
    @Path(value="/{dashboardId}/widgets/{widgetId}/value")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found."), @ApiResponse(code=403, message="Request must be performed against master node."), @ApiResponse(code=504, message="Computation failed on indexer side.")})
    @Produces(value={"application/json"})
    public Map<String, Object> widgetValue(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId) {
        this.restrictToMaster();
        this.checkPermission("dashboards:read", dashboardId);
        Dashboard dashboard = this.dashboardRegistry.get(dashboardId);
        if (dashboard == null) {
            LOG.error("Dashboard not found.");
            throw new NotFoundException();
        }
        DashboardWidget widget = dashboard.getWidget(widgetId);
        if (widget == null) {
            LOG.error("Widget not found.");
            throw new NotFoundException();
        }
        try {
            return widget.getComputationResult().asMap();
        }
        catch (ExecutionException e) {
            LOG.error("Error while computing dashboard.", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.GATEWAY_TIMEOUT);
        }
    }

    @PUT
    @Timed
    @ApiOperation(value="Update description of a widget")
    @Path(value="/{dashboardId}/widgets/{widgetId}/description")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found."), @ApiResponse(code=403, message="Request must be performed against master node.")})
    @Produces(value={"application/json"})
    public void updateDescription(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId, @ApiParam(name="JSON body", required=true) @Valid UpdateWidgetRequest uwr) throws ValidationException {
        this.restrictToMaster();
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardRegistry.get(dashboardId);
        if (dashboard == null) {
            LOG.error("Dashboard not found.");
            throw new NotFoundException();
        }
        DashboardWidget widget = dashboard.getWidget(widgetId);
        if (widget == null) {
            LOG.error("Widget not found.");
            throw new NotFoundException();
        }
        this.dashboardService.updateWidgetDescription(dashboard, widget, uwr.description());
        LOG.info("Updated description of widget <" + widgetId + "> on dashboard <" + dashboardId + ">. Reason: REST request.");
    }

    @PUT
    @Timed
    @ApiOperation(value="Update cache time of a widget")
    @Path(value="/{dashboardId}/widgets/{widgetId}/cachetime")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found."), @ApiResponse(code=404, message="Widget not found."), @ApiResponse(code=403, message="Request must be performed against master node.")})
    @Produces(value={"application/json"})
    public void updateCacheTime(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="widgetId", required=true) @PathParam(value="widgetId") String widgetId, @ApiParam(name="JSON body", required=true) @Valid UpdateWidgetRequest uwr) throws ValidationException {
        this.restrictToMaster();
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardRegistry.get(dashboardId);
        if (dashboard == null) {
            LOG.error("Dashboard not found.");
            throw new NotFoundException();
        }
        DashboardWidget widget = dashboard.getWidget(widgetId);
        if (widget == null) {
            LOG.error("Widget not found.");
            throw new NotFoundException();
        }
        this.dashboardService.updateWidgetCacheTime(dashboard, widget, uwr.cacheTime());
        LOG.info("Updated cache time of widget <" + widgetId + "> on dashboard <" + dashboardId + "> to " + "[" + uwr.cacheTime() + "]. Reason: REST request.");
    }
}

