/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.outputs;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.database.NotFoundException;
import org.graylog2.outputs.OutputRegistry;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.system.outputs.responses.OutputSummary;
import org.graylog2.rest.resources.streams.outputs.AddOutputRequest;
import org.graylog2.rest.resources.streams.outputs.OutputListResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.StreamService;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="StreamOutputs", description="Manage stream outputs for a given stream")
@Path(value="/streams/{streamid}/outputs")
public class StreamOutputResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(StreamOutputResource.class);
    private final OutputService outputService;
    private final StreamService streamService;
    private final OutputRegistry outputRegistry;

    @Inject
    public StreamOutputResource(OutputService outputService, StreamService streamService, OutputRegistry outputRegistry) {
        this.outputService = outputService;
        this.streamService = streamService;
        this.outputRegistry = outputRegistry;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all outputs for a stream")
    @RequiresPermissions(value={"stream_outputs:create"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="No such stream on this node.")})
    public OutputListResponse get(@ApiParam(name="streamid", value="The id of the stream whose outputs we want.", required=true) @PathParam(value="streamid") String streamid) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        this.checkPermission("stream_outputs:read");
        Stream stream = this.streamService.load(streamid);
        HashSet<OutputSummary> outputs = new HashSet<OutputSummary>();
        for (Output output : stream.getOutputs()) {
            outputs.add(OutputSummary.create((String)output.getId(), (String)output.getTitle(), (String)output.getType(), (String)output.getCreatorUserId(), (DateTime)new DateTime((Object)output.getCreatedAt()), new HashMap(output.getConfiguration()), (String)output.getContentPack()));
        }
        return OutputListResponse.create(outputs);
    }

    @GET
    @Path(value="/{outputId}")
    @Timed
    @ApiOperation(value="Get specific output of a stream")
    @RequiresPermissions(value={"stream_outputs:read"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="No such stream/output on this node.")})
    public OutputSummary get(@ApiParam(name="streamid", value="The id of the stream whose outputs we want.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="outputId", value="The id of the output we want.", required=true) @PathParam(value="outputId") String outputId) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        this.checkPermission("stream_outputs:read", outputId);
        Output output = this.outputService.load(outputId);
        return OutputSummary.create((String)output.getId(), (String)output.getTitle(), (String)output.getType(), (String)output.getCreatorUserId(), (DateTime)new DateTime((Object)output.getCreatedAt()), (Map)output.getConfiguration(), (String)output.getContentPack());
    }

    @POST
    @Timed
    @ApiOperation(value="Associate outputs with a stream")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"stream_outputs:create"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid output specification in input.")})
    public Response add(@ApiParam(name="streamid", value="The id of the stream whose outputs we want.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="JSON body", required=true) @Valid @NotNull AddOutputRequest aor) throws ValidationException, NotFoundException {
        Stream stream = this.streamService.load(streamid);
        for (String outputId : aor.outputs()) {
            Output output = this.outputService.load(outputId);
            this.streamService.addOutput(stream, output);
        }
        return Response.accepted().build();
    }

    @DELETE
    @Path(value="/{outputId}")
    @Timed
    @RequiresPermissions(value={"stream_outputs:delete"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete output of a stream")
    @ApiResponses(value={@ApiResponse(code=404, message="No such stream/output on this node.")})
    public void remove(@ApiParam(name="streamid", value="The id of the stream whose outputs we want.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="outputId", value="The id of the output that should be deleted", required=true) @PathParam(value="outputId") String outputId) throws NotFoundException {
        Stream stream = this.streamService.load(streamid);
        Output output = this.outputService.load(outputId);
        this.streamService.removeOutput(stream, output);
        this.outputRegistry.removeOutput(output);
    }
}

