/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.Configuration;
import org.graylog2.buffers.OutputBuffer;
import org.graylog2.plugin.buffers.InputBuffer;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/Buffers", description="Buffer information of this node.")
@Path(value="/system/buffers")
public class BufferResource
extends RestResource {
    private final Configuration configuration;
    private final InputBuffer inputBuffer;
    private final ProcessBuffer processBuffer;
    private final OutputBuffer outputBuffer;

    @Inject
    public BufferResource(Configuration configuration, InputBuffer inputBuffer, ProcessBuffer processBuffer, OutputBuffer outputBuffer) {
        this.configuration = configuration;
        this.inputBuffer = inputBuffer;
        this.processBuffer = processBuffer;
        this.outputBuffer = outputBuffer;
    }

    @GET
    @Timed
    @ApiOperation(value="Get current utilization of buffers and caches of this node.")
    @RequiresPermissions(value={"buffers:read"})
    @Produces(value={"application/json"})
    public Map<String, Map<String, Object>> utilization() {
        return ImmutableMap.of((Object)"buffers", this.buffers());
    }

    @GET
    @Timed
    @Path(value="/classes")
    @ApiOperation(value="Get classnames of current buffer implementations.")
    @RequiresPermissions(value={"buffers:read"})
    @Produces(value={"application/json"})
    public Map<String, String> getBufferClasses() {
        return ImmutableMap.of((Object)"input_buffer", (Object)this.inputBuffer.getClass().getCanonicalName(), (Object)"process_buffer", (Object)this.processBuffer.getClass().getCanonicalName(), (Object)"output_buffer", (Object)((Object)((Object)this.outputBuffer)).getClass().getCanonicalName());
    }

    private Map<String, Object> buffers() {
        HashMap buffers = Maps.newHashMap();
        HashMap input = Maps.newHashMap();
        HashMap process = Maps.newHashMap();
        HashMap output = Maps.newHashMap();
        long ringSize = this.configuration.getRingSize();
        long inputRingSize = this.configuration.getInputBufferRingSize();
        long inputSize = this.inputBuffer.size();
        float inputUtil = (float)inputSize / (float)inputRingSize * 100.0f;
        input.put("utilization_percent", Float.valueOf(inputUtil));
        input.put("utilization", inputSize);
        long processSize = this.processBuffer.size();
        float processUtil = (float)processSize / (float)ringSize * 100.0f;
        process.put("utilization_percent", Float.valueOf(processUtil));
        process.put("utilization", processSize);
        long outputSize = this.outputBuffer.size();
        float outputUtil = (float)outputSize / (float)ringSize * 100.0f;
        output.put("utilization_percent", Float.valueOf(outputUtil));
        output.put("utilization", outputSize);
        buffers.put("input", input);
        buffers.put("process", process);
        buffers.put("output", output);
        return buffers;
    }
}

