/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.rotation.MessageCountRotationStrategy;
import org.graylog2.indexer.rotation.SizeBasedRotationStrategy;
import org.graylog2.indexer.rotation.TimeBasedRotationStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.rest.resources.system.TimeBasedRotationStrategyResponse;
import org.graylog2.rest.resources.system.responses.DeflectorConfigResponse;
import org.graylog2.rest.resources.system.responses.MessageCountRotationStrategyResponse;
import org.graylog2.rest.resources.system.responses.SizeBasedRotationStrategyResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Deflector", description="Index deflector management")
@Path(value="/system/deflector")
public class DeflectorResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(DeflectorResource.class);
    private final Deflector deflector;
    private final ActivityWriter activityWriter;
    private final Provider<RotationStrategy> rotationStrategyProvider;
    private final ElasticsearchConfiguration configuration;

    @Inject
    public DeflectorResource(Deflector deflector, ActivityWriter activityWriter, Provider<RotationStrategy> rotationStrategyProvider, ElasticsearchConfiguration configuration) {
        this.deflector = deflector;
        this.activityWriter = activityWriter;
        this.rotationStrategyProvider = rotationStrategyProvider;
        this.configuration = configuration;
    }

    @GET
    @Timed
    @ApiOperation(value="Get current deflector status")
    @RequiresPermissions(value={"deflector:read"})
    @Produces(value={"application/json"})
    public Map<String, Object> deflector() {
        return ImmutableMap.of((Object)"is_up", (Object)this.deflector.isUp(), (Object)"current_target", (Object)this.deflector.getCurrentActualTargetIndex());
    }

    @GET
    @Timed
    @ApiOperation(value="Get deflector configuration. Only available on master nodes.")
    @RequiresPermissions(value={"deflector:read"})
    @Path(value="/config")
    @Produces(value={"application/json"})
    public DeflectorConfigResponse config() {
        this.restrictToMaster();
        RotationStrategy strategy = (RotationStrategy)this.rotationStrategyProvider.get();
        DeflectorConfigResponse response = null;
        if (strategy instanceof MessageCountRotationStrategy) {
            response = new MessageCountRotationStrategyResponse(this.configuration.getMaxDocsPerIndex());
        } else if (strategy instanceof SizeBasedRotationStrategy) {
            response = new SizeBasedRotationStrategyResponse(this.configuration.getMaxSizePerIndex());
        } else if (strategy instanceof TimeBasedRotationStrategy) {
            response = new TimeBasedRotationStrategyResponse(this.configuration.getMaxTimePerIndex());
        } else {
            throw new InternalServerErrorException("Unknown rotation strategy!");
        }
        response.maxNumberOfIndices = this.configuration.getMaxNumberOfIndices();
        return response;
    }

    @POST
    @Timed
    @ApiOperation(value="Cycle deflector to new/next index")
    @RequiresPermissions(value={"deflector:cycle"})
    @Path(value="/cycle")
    public void cycle() {
        this.restrictToMaster();
        String msg = "Cycling deflector. Reason: REST request.";
        LOG.info("Cycling deflector. Reason: REST request.");
        this.activityWriter.write(new Activity("Cycling deflector. Reason: REST request.", DeflectorResource.class));
        this.deflector.cycle();
    }
}

