/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.plugin.lifecycles.LoadBalancerStatus;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="System/LoadBalancers", description="Status propagation for load balancers")
@Path(value="/system/lbstatus")
public class LoadBalancerStatusResource
extends RestResource {
    @GET
    @Timed
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get status of this graylog2-server node for load balancers. Returns either ALIVE with HTTP 200 or DEAD with HTTP 503.")
    public Response status() {
        LoadBalancerStatus lbStatus = this.serverStatus.getLifecycle().getLoadbalancerStatus();
        Response.Status status = lbStatus == LoadBalancerStatus.ALIVE ? Response.Status.OK : Response.Status.SERVICE_UNAVAILABLE;
        return Response.status((Response.Status)status).entity((Object)lbStatus.toString().toUpperCase()).build();
    }

    @PUT
    @Timed
    @RequiresAuthentication
    @RequiresPermissions(value={"lbstatus:change"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Override load balancer status of this graylog2-server node. Next lifecycle change will override it again to its default. Set to ALIVE or DEAD.")
    @Path(value="/override/{status}")
    public void override(@ApiParam(name="status") @PathParam(value="status") String status) {
        LoadBalancerStatus lbStatus;
        try {
            lbStatus = LoadBalancerStatus.valueOf((String)status.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
        switch (lbStatus) {
            case DEAD: {
                this.serverStatus.overrideLoadBalancerDead();
                break;
            }
            case ALIVE: {
                this.serverStatus.overrideLoadBalancerAlive();
            }
        }
    }
}

