/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Version;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="System/Plugin", description="Plugin information")
@Path(value="/system/plugins")
@Produces(value={"application/json"})
public class PluginResource
extends RestResource {
    private final Set<PluginMetaData> pluginMetaDataSet;

    @Inject
    public PluginResource(Set<PluginMetaData> pluginMetaDataSet) {
        this.pluginMetaDataSet = pluginMetaDataSet;
    }

    @GET
    @Timed
    @ApiOperation(value="List all installed plugins on this node.")
    public Map<String, Object> list() {
        ArrayList pluginMetaDataValues = Lists.newArrayList();
        for (PluginMetaData pluginMetaData : this.pluginMetaDataSet) {
            pluginMetaDataValues.add(new PluginMetaDataValue(pluginMetaData));
        }
        return ImmutableMap.of((Object)"plugins", (Object)pluginMetaDataValues, (Object)"total", (Object)pluginMetaDataValues.size());
    }

    static class PluginMetaDataValue {
        public final String unique_id;
        public final String name;
        public final String author;
        public final URI url;
        public final Version version;
        public final String description;
        public final Version required_version;
        public final Set<ServerStatus.Capability> required_capabilities;

        PluginMetaDataValue(PluginMetaData pluginMetaData) {
            this.unique_id = pluginMetaData.getUniqueId();
            this.name = pluginMetaData.getName();
            this.author = pluginMetaData.getAuthor();
            this.url = pluginMetaData.getURL();
            this.version = pluginMetaData.getVersion();
            this.description = pluginMetaData.getDescription();
            this.required_version = pluginMetaData.getRequiredVersion();
            this.required_capabilities = pluginMetaData.getRequiredCapabilities();
        }
    }
}

