/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.codahale.metrics.jvm.ThreadDump;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.ServerVersion;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.plugin.ProcessingPauseLockedException;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.rest.resources.system.responses.ReaderPermissionResponse;
import org.graylog2.security.RestPermissions;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.shutdown.GracefulShutdown;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System", description="System information of this node.")
@Path(value="/system")
public class SystemResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SystemResource.class);
    private final ServerStatus serverStatus;
    private final GracefulShutdown gracefulShutdown;
    private final Indices indices;

    @Inject
    public SystemResource(ServerStatus serverStatus, Indices indices, GracefulShutdown gracefulShutdown) {
        this.serverStatus = serverStatus;
        this.indices = indices;
        this.gracefulShutdown = gracefulShutdown;
    }

    @GET
    @Timed
    @ApiOperation(value="Get system overview")
    @Produces(value={"application/json"})
    public Map<String, Object> system() {
        this.checkPermission("system:read", this.serverStatus.getNodeId().toString());
        HashMap result = Maps.newHashMap();
        result.put("facility", "graylog2-server");
        result.put("codename", "Jever");
        result.put("server_id", this.serverStatus.getNodeId().toString());
        result.put("version", ServerVersion.VERSION.toString());
        result.put("started_at", Tools.getISO8601String((DateTime)this.serverStatus.getStartedAt()));
        result.put("is_processing", this.serverStatus.isProcessing());
        result.put("hostname", Tools.getLocalCanonicalHostname());
        result.put("lifecycle", this.serverStatus.getLifecycle().getDescription().toLowerCase());
        result.put("lb_status", this.serverStatus.getLifecycle().getLoadbalancerStatus().toString().toLowerCase());
        result.put("timezone", this.serverStatus.getTimezone().getID());
        return result;
    }

    @GET
    @Timed
    @ApiOperation(value="Get list of message fields that exist", notes="This operation is comparably fast because it reads directly from the indexer mapping.")
    @Path(value="/fields")
    @RequiresPermissions(value={"fieldnames:read"})
    @Produces(value={"application/json"})
    public Map<String, Set<String>> fields(@ApiParam(name="limit", value="Maximum number of fields to return. Set to 0 for all fields.", required=false) @QueryParam(value="limit") int limit) {
        Set<Object> fields;
        boolean unlimited;
        boolean bl = unlimited = limit <= 0;
        if (unlimited) {
            fields = this.indices.getAllMessageFields();
        } else {
            fields = Sets.newHashSet();
            this.addStandardFields((Set<String>)fields);
            int i = 0;
            for (String field : this.indices.getAllMessageFields()) {
                if (i == limit) break;
                fields.add(field);
                ++i;
            }
        }
        return ImmutableMap.of((Object)"fields", (Object)fields);
    }

    private void addStandardFields(Set<String> fields) {
        fields.add("source");
        fields.add("message");
        fields.add("timestamp");
    }

    @PUT
    @Timed
    @ApiOperation(value="Pauses message processing", notes="If the message journal is enabled, incoming messages will be spooled on disk, if it is disabled, you might lose messages from inputs which cannot buffer themselves, like AMQP or Kafka-based inputs.")
    @Path(value="/processing/pause")
    public void pauseProcessing() {
        this.checkPermission("processing:changestate", this.serverStatus.getNodeId().toString());
        this.serverStatus.pauseMessageProcessing(false);
        LOG.info("Paused message processing - triggered by REST call.");
    }

    @PUT
    @Timed
    @ApiOperation(value="Resume message processing")
    @Path(value="/processing/resume")
    public void resumeProcessing() {
        this.checkPermission("processing:changestate", this.serverStatus.getNodeId().toString());
        try {
            this.serverStatus.resumeMessageProcessing();
        }
        catch (ProcessingPauseLockedException e) {
            LOG.error("Message processing pause is locked. Returning HTTP 403.");
            throw new ForbiddenException((Throwable)e);
        }
        LOG.info("Resumed message processing - triggered by REST call.");
    }

    @PUT
    @Timed
    @Path(value="/processing/pause/unlock")
    public void unlockProcessingPause() {
        this.checkPermission("processing:changestate", this.serverStatus.getNodeId().toString());
        this.serverStatus.unlockProcessingPause();
        LOG.info("Manually unlocked message processing pause - triggered by REST call.");
    }

    @GET
    @ApiOperation(value="Get JVM information")
    @Path(value="/jvm")
    @Timed
    @Produces(value={"application/json"})
    public Map<String, Object> jvm() {
        this.checkPermission("jvmstats:read", this.serverStatus.getNodeId().toString());
        Runtime runtime = Runtime.getRuntime();
        HashMap result = Maps.newHashMap();
        result.put("free_memory", this.bytesToValueMap(runtime.freeMemory()));
        result.put("max_memory", this.bytesToValueMap(runtime.maxMemory()));
        result.put("total_memory", this.bytesToValueMap(runtime.totalMemory()));
        result.put("used_memory", this.bytesToValueMap(runtime.totalMemory() - runtime.freeMemory()));
        result.put("node_id", this.serverStatus.getNodeId().toString());
        result.put("pid", Tools.getPID());
        result.put("info", Tools.getSystemInformation());
        return result;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a thread dump")
    @Path(value="/threaddump")
    @Produces(value={"text/plain"})
    public String threaddump() {
        this.checkPermission("threads:dump", this.serverStatus.getNodeId().toString());
        ThreadDump threadDump = new ThreadDump(ManagementFactory.getThreadMXBean());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        threadDump.dump((OutputStream)output);
        return new String(output.toByteArray(), StandardCharsets.UTF_8);
    }

    @GET
    @Timed
    @RequiresGuest
    @ApiOperation(value="Get all available user permissions.")
    @Path(value="/permissions")
    @Produces(value={"application/json"})
    public Map<String, Map<String, Collection<String>>> permissions() {
        return ImmutableMap.of((Object)"permissions", RestPermissions.allPermissions());
    }

    @GET
    @Timed
    @RequiresGuest
    @ApiOperation(value="Get the initial permissions assigned to a reader account")
    @Path(value="/permissions/reader/{username}")
    @Produces(value={"application/json"})
    public ReaderPermissionResponse readerPermissions(@ApiParam(name="username", required=true) @PathParam(value="username") String username) {
        return ReaderPermissionResponse.create(Ordering.natural().sortedCopy(RestPermissions.readerPermissions(username)));
    }

    @POST
    @Timed
    @ApiOperation(value="Shutdown this node gracefully.", notes="Attempts to process all buffered and cached messages before exiting, shuts down inputs first to make sure that no new messages are accepted.")
    @Path(value="/shutdown")
    public Response shutdown() {
        this.checkPermission("node:shutdown", this.serverStatus.getNodeId().toString());
        new Thread(this.gracefulShutdown).start();
        return Response.accepted().build();
    }
}

