/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.indices.IndexStatistics;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.ranges.RebuildIndexRangesJob;
import org.graylog2.rest.resources.system.indexer.responses.ClosedIndices;
import org.graylog2.rest.resources.system.indexer.responses.IndexInfo;
import org.graylog2.rest.resources.system.indexer.responses.IndexStats;
import org.graylog2.rest.resources.system.indexer.responses.ShardRouting;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.jobs.SystemJobConcurrencyException;
import org.graylog2.system.jobs.SystemJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Indexer/Indices", description="Index information")
@Path(value="/system/indexer/indices")
public class IndicesResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(IndicesResource.class);
    @Inject
    private RebuildIndexRangesJob.Factory rebuildIndexRangesJobFactory;
    @Inject
    private Indices indices;
    @Inject
    private Cluster cluster;
    @Inject
    private Deflector deflector;
    @Inject
    private SystemJobManager systemJobManager;

    @GET
    @Timed
    @Path(value="/{index}")
    @ApiOperation(value="Get information of an index and its shards.")
    @Produces(value={"application/json"})
    public IndexInfo single(@ApiParam(name="index") @PathParam(value="index") String index) {
        this.checkPermission("indices:read", index);
        if (!this.deflector.isGraylog2Index(index)) {
            String msg = "Index [" + index + "]\u00a0doesn't look like an index managed by Graylog.";
            LOG.info(msg);
            throw new NotFoundException(msg);
        }
        IndexStatistics stats = this.indices.getIndexStats(index);
        if (stats == null) {
            String msg = "Index [" + index + "]\u00a0not found.";
            LOG.error(msg);
            throw new NotFoundException(msg);
        }
        ImmutableList.Builder routing = ImmutableList.builder();
        for (org.elasticsearch.cluster.routing.ShardRouting shardRouting : stats.getShardRoutings()) {
            routing.add((Object)this.shardRouting(shardRouting));
        }
        return IndexInfo.create(this.indexStats(stats.getPrimaries()), this.indexStats(stats.getTotal()), (List<ShardRouting>)routing.build(), this.indices.isReopened(index));
    }

    @GET
    @Timed
    @Path(value="/closed")
    @ApiOperation(value="Get a list of closed indices that can be reopened.")
    @Produces(value={"application/json"})
    public ClosedIndices closed() {
        Set closedIndices;
        try {
            closedIndices = Sets.filter(this.indices.getClosedIndices(), (Predicate)new Predicate<String>(){

                public boolean apply(String indexName) {
                    return IndicesResource.this.isPermitted("indices:read", indexName);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Could not get closed indices.", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
        return ClosedIndices.create(closedIndices, closedIndices.size());
    }

    @GET
    @Timed
    @Path(value="/reopened")
    @ApiOperation(value="Get a list of reopened indices, which will not be cleaned by retention cleaning")
    @Produces(value={"application/json"})
    public ClosedIndices reopened() {
        Set reopenedIndices;
        try {
            reopenedIndices = Sets.filter(this.indices.getReopenedIndices(), (Predicate)new Predicate<String>(){

                public boolean apply(String indexName) {
                    return IndicesResource.this.isPermitted("indices:read", indexName);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Could not get reopened indices.", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
        return ClosedIndices.create(reopenedIndices, reopenedIndices.size());
    }

    @POST
    @Timed
    @Path(value="/{index}/reopen")
    @ApiOperation(value="Reopen a closed index. This will also trigger an index ranges rebuild job.")
    @Produces(value={"application/json"})
    public void reopen(@ApiParam(name="index") @PathParam(value="index") String index) {
        this.checkPermission("indices:changestate", index);
        if (!this.deflector.isGraylog2Index(index)) {
            LOG.info("Index [{}]\u00a0doesn't look like an index managed by Graylog.", (Object)index);
            throw new NotFoundException();
        }
        this.indices.reopenIndex(index);
        RebuildIndexRangesJob rebuildJob = this.rebuildIndexRangesJobFactory.create(this.deflector);
        try {
            this.systemJobManager.submit(rebuildJob);
        }
        catch (SystemJobConcurrencyException e) {
            String msg = "Concurrency level of this job reached: " + e.getMessage();
            LOG.error(msg);
            throw new ForbiddenException(msg);
        }
    }

    @POST
    @Timed
    @Path(value="/{index}/close")
    @ApiOperation(value="Close an index. This will also trigger an index ranges rebuild job.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="You cannot close the current deflector target index.")})
    public void close(@ApiParam(name="index") @PathParam(value="index") String index) {
        this.checkPermission("indices:changestate", index);
        if (!this.deflector.isGraylog2Index(index)) {
            LOG.info("Index [{}]\u00a0doesn't look like an index managed by Graylog.", (Object)index);
            throw new NotFoundException();
        }
        if (this.deflector.getCurrentActualTargetIndex().equals(index)) {
            throw new ForbiddenException();
        }
        this.indices.close(index);
        RebuildIndexRangesJob rebuildJob = this.rebuildIndexRangesJobFactory.create(this.deflector);
        try {
            this.systemJobManager.submit(rebuildJob);
        }
        catch (SystemJobConcurrencyException e) {
            String msg = "Concurrency level of this job reached: " + e.getMessage();
            LOG.error(msg);
            throw new ForbiddenException(msg);
        }
    }

    @DELETE
    @Timed
    @Path(value="/{index}")
    @ApiOperation(value="Delete an index. This will also trigger an index ranges rebuild job.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="You cannot delete the current deflector target index.")})
    public void delete(@ApiParam(name="index") @PathParam(value="index") String index) {
        this.checkPermission("indices:delete", index);
        if (!this.deflector.isGraylog2Index(index)) {
            String msg = "Index [" + index + "]\u00a0doesn't look like an index managed by Graylog.";
            LOG.info(msg);
            throw new NotFoundException(msg);
        }
        if (this.deflector.getCurrentActualTargetIndex().equals(index)) {
            throw new ForbiddenException();
        }
        this.indices.delete(index);
        RebuildIndexRangesJob rebuildJob = this.rebuildIndexRangesJobFactory.create(this.deflector);
        try {
            this.systemJobManager.submit(rebuildJob);
        }
        catch (SystemJobConcurrencyException e) {
            String msg = "Concurrency level of this job reached: " + e.getMessage();
            LOG.error(msg);
            throw new ForbiddenException(msg);
        }
    }

    private ShardRouting shardRouting(org.elasticsearch.cluster.routing.ShardRouting route) {
        return ShardRouting.create(route.shardId().getId(), route.state().name().toLowerCase(), route.active(), route.primary(), route.currentNodeId(), this.cluster.nodeIdToName(route.currentNodeId()), this.cluster.nodeIdToHostName(route.currentNodeId()), route.relocatingNodeId());
    }

    private IndexStats indexStats(CommonStats stats) {
        return IndexStats.create(IndexStats.TimeAndTotalStats.create(stats.getFlush().getTotal(), stats.getFlush().getTotalTime().getSeconds()), IndexStats.TimeAndTotalStats.create(stats.getGet().getCount(), stats.getGet().getTime().getSeconds()), IndexStats.TimeAndTotalStats.create(stats.getIndexing().getTotal().getIndexCount(), stats.getIndexing().getTotal().getIndexTime().getSeconds()), IndexStats.TimeAndTotalStats.create(stats.getMerge().getTotal(), stats.getMerge().getTotalTime().getSeconds()), IndexStats.TimeAndTotalStats.create(stats.getRefresh().getTotal(), stats.getRefresh().getTotalTime().getSeconds()), IndexStats.TimeAndTotalStats.create(stats.getSearch().getTotal().getQueryCount(), stats.getSearch().getTotal().getQueryTime().getSeconds()), IndexStats.TimeAndTotalStats.create(stats.getSearch().getTotal().getFetchCount(), stats.getSearch().getTotal().getFetchTime().getSeconds()), stats.getSearch().getOpenContexts(), stats.getStore().getSize().getBytes(), stats.getSegments().getCount(), IndexStats.DocsStats.create(stats.getDocs().getCount(), stats.getDocs().getDeleted()));
    }
}

