/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.inputs;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import com.eaio.uuid.UUID;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.ConfigurationException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.inputs.converters.ConverterFactory;
import org.graylog2.inputs.extractors.ExtractorFactory;
import org.graylog2.metrics.MetricUtils;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.rest.resources.system.inputs.InputsResource;
import org.graylog2.rest.resources.system.inputs.requests.CreateExtractorRequest;
import org.graylog2.rest.resources.system.inputs.requests.OrderExtractorsRequest;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.inputs.PersistedInputs;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Extractors", description="Extractors of an input")
@Path(value="/system/inputs/{inputId}/extractors")
public class ExtractorsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractorsResource.class);
    private final InputService inputService;
    private final ActivityWriter activityWriter;
    private final InputRegistry inputs;
    private final MetricRegistry metricRegistry;
    private final ExtractorFactory extractorFactory;
    private final PersistedInputs persistedInputs;

    @Inject
    public ExtractorsResource(InputService inputService, ActivityWriter activityWriter, InputRegistry inputs, MetricRegistry metricRegistry, ExtractorFactory extractorFactory, PersistedInputs persistedInputs) {
        this.inputService = inputService;
        this.activityWriter = activityWriter;
        this.inputs = inputs;
        this.metricRegistry = metricRegistry;
        this.extractorFactory = extractorFactory;
        this.persistedInputs = persistedInputs;
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add an extractor to an input")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=400, message="No such extractor type."), @ApiResponse(code=400, message="Field the extractor should write on is reserved."), @ApiResponse(code=400, message="Missing or invalid configuration.")})
    public Response create(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateExtractorRequest cer) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputId);
        MessageInput input = this.inputs.getRunningInput(inputId);
        if (input == null) {
            LOG.error("Input <{}> not found.", (Object)inputId);
            throw new NotFoundException();
        }
        Input mongoInput = this.inputService.find(input.getPersistId());
        String id = new UUID().toString();
        Extractor extractor = this.buildExtractorFromRequest(cer, id);
        try {
            this.inputService.addExtractor(mongoInput, extractor);
        }
        catch (ValidationException e) {
            LOG.error("Extractor persist validation failed.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        String msg = "Added extractor <" + id + "> of type [" + cer.extractorType() + "] to input <" + inputId + ">.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, ExtractorsResource.class));
        ImmutableMap result = ImmutableMap.of((Object)"extractor_id", (Object)id);
        URI extractorUri = this.getUriBuilderToSelf().path(ExtractorsResource.class).path("{inputId}").build(new Object[]{input.getId()});
        return Response.created((URI)extractorUri).entity((Object)result).build();
    }

    @PUT
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an extractor")
    @Path(value="/{extractorId}")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=404, message="No such extractor on this input."), @ApiResponse(code=400, message="No such extractor type."), @ApiResponse(code=400, message="Field the extractor should write on is reserved."), @ApiResponse(code=400, message="Missing or invalid configuration.")})
    public Map<String, Object> update(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="extractorId", required=true) @PathParam(value="extractorId") String extractorId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateExtractorRequest cer) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputId);
        MessageInput input = this.persistedInputs.get(inputId);
        if (input == null) {
            LOG.error("Input <{}> not found.", (Object)inputId);
            throw new NotFoundException("Couldn't find input " + inputId);
        }
        Input mongoInput = this.inputService.find(input.getPersistId());
        Extractor originalExtractor = this.inputService.getExtractor(mongoInput, extractorId);
        Extractor extractor = this.buildExtractorFromRequest(cer, originalExtractor.getId());
        this.inputService.removeExtractor(mongoInput, originalExtractor.getId());
        try {
            this.inputService.addExtractor(mongoInput, extractor);
        }
        catch (ValidationException e) {
            LOG.error("Extractor persist validation failed.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        String msg = "Updated extractor <" + originalExtractor.getId() + "> of type [" + cer.extractorType() + "] in input <" + inputId + ">.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, ExtractorsResource.class));
        return this.toMap(extractor);
    }

    @GET
    @Timed
    @ApiOperation(value="List all extractors of an input")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    @Produces(value={"application/json"})
    public Map<String, Object> list(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:read", inputId);
        Input input = this.inputService.find(inputId);
        if (input == null) {
            LOG.error("Input <{}> not found.", (Object)inputId);
            throw new NotFoundException();
        }
        ArrayList extractors = Lists.newArrayList();
        for (Extractor extractor : this.inputService.getExtractors(input)) {
            extractors.add(this.toMap(extractor));
        }
        return ImmutableMap.of((Object)"extractors", (Object)extractors, (Object)"total", (Object)this.inputService.getExtractors(input).size());
    }

    @GET
    @Timed
    @ApiOperation(value="Get information of a single extractor of an input")
    @Path(value="/{extractorId}")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=404, message="No such extractor on this input.")})
    @Produces(value={"application/json"})
    public Map<String, Object> single(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="extractorId", required=true) @PathParam(value="extractorId") String extractorId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:read", inputId);
        MessageInput input = this.persistedInputs.get(inputId);
        if (input == null) {
            LOG.error("Input <{}> not found.", (Object)inputId);
            throw new NotFoundException("Couldn't find input " + inputId);
        }
        Input mongoInput = this.inputService.find(input.getPersistId());
        Extractor extractor = this.inputService.getExtractor(mongoInput, extractorId);
        return this.toMap(extractor);
    }

    @DELETE
    @Timed
    @ApiOperation(value="Delete an extractor")
    @Path(value="/{extractorId}")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request."), @ApiResponse(code=404, message="Input not found."), @ApiResponse(code=404, message="Extractor not found.")})
    @Produces(value={"application/json"})
    public void terminate(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="extractorId", required=true) @PathParam(value="extractorId") String extractorId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputId);
        MessageInput input = this.persistedInputs.get(inputId);
        if (input == null) {
            LOG.error("Input <{}> not found.", (Object)inputId);
            throw new NotFoundException("Couldn't find input " + inputId);
        }
        Input mongoInput = this.inputService.find(input.getPersistId());
        Extractor extractor = this.inputService.getExtractor(mongoInput, extractorId);
        this.inputService.removeExtractor(mongoInput, extractor.getId());
        String msg = "Deleted extractor <" + extractorId + "> of type [" + extractor.getType() + "] " + "from input <" + inputId + ">.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, InputsResource.class));
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update extractor order of an input")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    @Path(value="order")
    public void order(@ApiParam(name="inputId", value="Persist ID (!) of input.", required=true) @PathParam(value="inputId") String inputPersistId, @ApiParam(name="JSON body", required=true) OrderExtractorsRequest oer) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputPersistId);
        Input mongoInput = this.inputService.find(inputPersistId);
        for (Extractor extractor : this.inputService.getExtractors(mongoInput)) {
            if (oer.order().containsValue(extractor.getId())) {
                extractor.setOrder((long)((Integer)Tools.getKeyByValue(oer.order(), (Object)extractor.getId())).intValue());
            }
            this.inputService.removeExtractor(mongoInput, extractor.getId());
            try {
                this.inputService.addExtractor(mongoInput, extractor);
            }
            catch (ValidationException e) {
                LOG.warn("Validation error for extractor update.", (Throwable)e);
            }
        }
        LOG.info("Updated extractor ordering of input <persist:{}>.", (Object)inputPersistId);
    }

    private Map<String, Object> toMap(Extractor extractor) {
        HashMap map = Maps.newHashMap();
        map.put("id", extractor.getId());
        map.put("title", extractor.getTitle());
        map.put("type", extractor.getType().toString().toLowerCase());
        map.put("cursor_strategy", extractor.getCursorStrategy().toString().toLowerCase());
        map.put("source_field", extractor.getSourceField());
        map.put("target_field", extractor.getTargetField());
        map.put("extractor_config", extractor.getExtractorConfig());
        map.put("creator_user_id", extractor.getCreatorUserId());
        map.put("converters", extractor.converterConfigMap());
        map.put("condition_type", extractor.getConditionType().toString().toLowerCase());
        map.put("condition_value", extractor.getConditionValue());
        map.put("order", extractor.getOrder());
        map.put("exceptions", extractor.getExceptionCount());
        map.put("converter_exceptions", extractor.getConverterExceptionCount());
        HashMap metrics = Maps.newHashMap();
        metrics.put("total", MetricUtils.buildTimerMap((Timer)this.metricRegistry.getTimers().get(extractor.getTotalTimerName())));
        metrics.put("converters", MetricUtils.buildTimerMap((Timer)this.metricRegistry.getTimers().get(extractor.getConverterTimerName())));
        map.put("metrics", metrics);
        return map;
    }

    private List<Converter> loadConverters(Map<String, Map<String, Object>> requestConverters) {
        ArrayList converters = Lists.newArrayList();
        for (Map.Entry<String, Map<String, Object>> c : requestConverters.entrySet()) {
            try {
                converters.add(ConverterFactory.factory(Converter.Type.valueOf((String)c.getKey().toUpperCase()), c.getValue()));
            }
            catch (ConverterFactory.NoSuchConverterException e) {
                LOG.warn("No such converter [" + c.getKey() + "]. Skipping.", (Throwable)e);
            }
            catch (ConfigurationException e) {
                LOG.warn("Missing configuration for [" + c.getKey() + "]. Skipping.", (Throwable)e);
            }
        }
        return converters;
    }

    private Extractor buildExtractorFromRequest(CreateExtractorRequest cer, String id) {
        Extractor extractor;
        try {
            extractor = this.extractorFactory.factory(id, cer.title(), cer.order(), Extractor.CursorStrategy.valueOf((String)cer.cutOrCopy().toUpperCase()), Extractor.Type.valueOf((String)cer.extractorType().toUpperCase()), cer.sourceField(), cer.targetField(), cer.extractorConfig(), this.getCurrentUser().getName(), this.loadConverters(cer.converters()), Extractor.ConditionType.valueOf((String)cer.conditionType().toUpperCase()), cer.conditionValue());
        }
        catch (ExtractorFactory.NoSuchExtractorException e) {
            LOG.error("No such extractor type.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        catch (Extractor.ReservedFieldException e) {
            LOG.error("Cannot create extractor. Field is reserved.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        catch (ConfigurationException e) {
            LOG.error("Cannot create extractor. Missing configuration.", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
        return extractor;
    }
}

