/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.security.AccessToken;
import org.graylog2.security.AccessTokenImpl;
import org.graylog2.security.AccessTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenServiceImpl
extends PersistedServiceImpl
implements AccessTokenService {
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenServiceImpl.class);
    private static final SecureRandom RANDOM = new SecureRandom();

    @Inject
    public AccessTokenServiceImpl(MongoConnection mongoConnection) {
        super(mongoConnection);
    }

    @Override
    public AccessToken load(String token) {
        BasicDBObject query = new BasicDBObject();
        query.put("token", (Object)token);
        List<DBObject> objects = this.query(AccessTokenImpl.class, (DBObject)query);
        if (objects.isEmpty()) {
            return null;
        }
        if (objects.size() > 1) {
            LOG.error("Multiple access tokens found, this is a serious bug.");
            throw new IllegalStateException("Access tokens collection has no unique index!");
        }
        DBObject tokenObject = objects.get(0);
        Object id = tokenObject.get("_id");
        return new AccessTokenImpl((ObjectId)id, tokenObject.toMap());
    }

    @Override
    public List<AccessToken> loadAll(String username) {
        BasicDBObject query = new BasicDBObject();
        query.put("username", (Object)username);
        List<DBObject> objects = this.query(AccessTokenImpl.class, (DBObject)query);
        ArrayList tokens = Lists.newArrayList();
        for (DBObject tokenObject : objects) {
            Object id = tokenObject.get("_id");
            AccessTokenImpl accessToken = new AccessTokenImpl((ObjectId)id, tokenObject.toMap());
            tokens.add(accessToken);
        }
        return tokens;
    }

    @Override
    public AccessToken create(String username, String name) {
        AccessTokenImpl accessToken;
        HashMap fields = Maps.newHashMap();
        String id = null;
        int iterations = 0;
        do {
            String token = new BigInteger(256, RANDOM).toString(32);
            fields.put("token", token);
            fields.put("username", username);
            fields.put("NAME", name);
            fields.put("last_access", Tools.dateTimeFromDouble((double)0.0));
            accessToken = new AccessTokenImpl(fields);
            try {
                id = this.saveWithoutValidation(accessToken);
            }
            catch (DuplicateKeyException ignore) {
                // empty catch block
            }
        } while (iterations++ < 10 && id == null);
        if (id == null) {
            throw new IllegalStateException("Could not create unique access token, tried 10 times. This is bad.");
        }
        return accessToken;
    }

    @Override
    public void touch(AccessToken accessToken) throws ValidationException {
        accessToken.getFields().put("last_access", Tools.iso8601());
        this.save(accessToken);
    }

    @Override
    public String save(AccessToken accessToken) throws ValidationException {
        this.collection(AccessTokenImpl.class).createIndex((DBObject)new BasicDBObject("token", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        return super.save(accessToken);
    }
}

