/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.plugin.database.validators.Validator;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CollectionName(value="sessions")
public class MongoDbSession
extends PersistedImpl {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbSession.class);

    protected MongoDbSession(Map<String, Object> fields) {
        super(fields);
    }

    public MongoDbSession(ObjectId objectId, Map map) {
        super(objectId, map);
    }

    public Map<String, Validator> getValidations() {
        return null;
    }

    public Map<String, Validator> getEmbeddedValidations(String key) {
        return null;
    }

    public Map<Object, Object> getAttributes() {
        Object attributes = this.fields.get("attributes");
        if (attributes == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream((byte[])attributes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object o = ois.readObject();
            return (Map)o;
        }
        catch (IOException e) {
            LOG.error("little io. wow.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("wrong thingy in db", (Throwable)e);
        }
        return null;
    }

    public void setAttributes(Map<Object, Object> attributes) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(attributes);
            oos.close();
            this.fields.put("attributes", bos.toByteArray());
        }
        catch (IOException e) {
            LOG.error("too bad :(", (Throwable)e);
        }
    }

    public String getHost() {
        return (String)this.fields.get("host");
    }

    public long getTimeout() {
        Object timeout = this.fields.get("timeout");
        if (timeout == null) {
            return 0L;
        }
        return (Long)timeout;
    }

    public Date getStartTimestamp() {
        return ((DateTime)this.fields.get("start_timestamp")).toDate();
    }

    public Date getLastAccessTime() {
        return ((DateTime)this.fields.get("last_access_time")).toDate();
    }

    public void setHost(String host) {
        this.fields.put("host", host);
    }

    public void setTimeout(long timeout) {
        this.fields.put("timeout", timeout);
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.fields.put("start_timestamp", startTimestamp);
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.fields.put("last_access_time", lastAccessTime);
    }

    public boolean isExpired() {
        Object o = this.fields.get("expired");
        return o == null ? false : (Boolean)o;
    }

    public void setExpired(boolean expired) {
        this.fields.put("expired", expired);
    }

    public String getSessionId() {
        return String.valueOf(this.fields.get("session_id"));
    }
}

