/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.bson.types.ObjectId;
import org.graylog2.database.CollectionName;
import org.graylog2.database.validators.FilledStringValidator;
import org.graylog2.database.validators.OptionalStringValidator;
import org.graylog2.plugin.database.validators.Validator;
import org.graylog2.plugin.streams.Output;

@CollectionName(value="outputs")
public class OutputImpl
implements Output {
    static final String FIELD_ID = "_id";
    static final String FIELD_TITLE = "title";
    static final String FIELD_TYPE = "type";
    static final String FIELD_CONFIGURATION = "configuration";
    static final String FIELD_CREATOR_USER_ID = "creator_user_id";
    static final String FIELD_CREATED_AT = "created_at";
    static final String FIELD_CONTENT_PACK = "content_pack";
    private ObjectId _id;
    private String title;
    private String type;
    private Map<String, Object> configuration;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="creator_user_id")
    private String creatorUserId;
    @Nullable
    private String contentPack = null;

    public OutputImpl() {
        this._id = new ObjectId();
    }

    public OutputImpl(String title, String type, Map<String, Object> configuration, Date createdAt, String creatorUserId) {
        this(title, type, configuration, createdAt, creatorUserId, null);
    }

    public OutputImpl(String title, String type, Map<String, Object> configuration, Date createdAt, String creatorUserId, @Nullable String contentPack) {
        this._id = new ObjectId();
        this.title = title;
        this.type = type;
        this.configuration = configuration;
        this.createdAt = createdAt;
        this.creatorUserId = creatorUserId;
        this.contentPack = contentPack;
    }

    public OutputImpl(ObjectId id, Map<String, Object> fields) {
        this._id = id;
        this.title = (String)fields.get(FIELD_TITLE);
        this.type = (String)fields.get(FIELD_TYPE);
        this.configuration = (Map)fields.get(FIELD_CONFIGURATION);
        this.createdAt = (Date)fields.get(FIELD_CREATED_AT);
        this.creatorUserId = (String)fields.get(FIELD_CREATOR_USER_ID);
        this.contentPack = (String)fields.get(FIELD_CONTENT_PACK);
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public Map<String, Validator> getValidations() {
        return ImmutableMap.of((Object)FIELD_TITLE, (Object)new FilledStringValidator(), (Object)FIELD_TYPE, (Object)new FilledStringValidator(), (Object)FIELD_CREATOR_USER_ID, (Object)new FilledStringValidator(), (Object)FIELD_CONTENT_PACK, (Object)new OptionalStringValidator());
    }

    public Map<String, Validator> getEmbeddedValidations(String key) {
        return Collections.emptyMap();
    }

    public String getId() {
        return this._id.toHexString();
    }

    public void setId(String id) {
        this._id = new ObjectId(id);
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    @Nullable
    public String getContentPack() {
        return this.contentPack;
    }

    public Map<String, Object> getFields() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put(FIELD_ID, new ObjectId(this.getId()));
        fields.put(FIELD_TITLE, this.getTitle());
        fields.put(FIELD_TYPE, this.getType());
        fields.put(FIELD_CONFIGURATION, this.getConfiguration());
        fields.put(FIELD_CREATOR_USER_ID, this.getCreatorUserId());
        fields.put(FIELD_CREATED_AT, this.getCreatedAt());
        fields.put(FIELD_CONTENT_PACK, this.getContentPack());
        return fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OutputImpl)) {
            return false;
        }
        OutputImpl output = (OutputImpl)o;
        if (!this._id.equals((Object)output._id)) {
            return false;
        }
        if (this.configuration != null ? !this.configuration.equals(output.configuration) : output.configuration != null) {
            return false;
        }
        if (this.contentPack != null ? !this.contentPack.equals(output.contentPack) : output.contentPack != null) {
            return false;
        }
        if (!this.createdAt.equals(output.createdAt)) {
            return false;
        }
        if (!this.creatorUserId.equals(output.creatorUserId)) {
            return false;
        }
        if (!this.title.equals(output.title)) {
            return false;
        }
        return this.type.equals(output.type);
    }

    public int hashCode() {
        int result = this._id.hashCode();
        result = 31 * result + this.title.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
        result = 31 * result + this.createdAt.hashCode();
        result = 31 * result + this.creatorUserId.hashCode();
        result = 31 * result + (this.contentPack != null ? this.contentPack.hashCode() : 0);
        return result;
    }

    @JsonValue
    public Map<String, Object> asMap() {
        Map<String, Object> fields = this.getFields();
        fields.put("id", ((ObjectId)fields.remove(FIELD_ID)).toHexString());
        return fields;
    }
}

