/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.alerts.AlertService;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.database.EmbeddedPersistable;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.rest.resources.streams.requests.CreateStreamRequest;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.StreamImpl;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamServiceImpl
extends PersistedServiceImpl
implements StreamService {
    private static final Logger LOG = LoggerFactory.getLogger(StreamServiceImpl.class);
    private final StreamRuleService streamRuleService;
    private final AlertService alertService;
    private final OutputService outputService;
    private final NotificationService notificationService;

    @Inject
    public StreamServiceImpl(MongoConnection mongoConnection, StreamRuleService streamRuleService, AlertService alertService, OutputService outputService, NotificationService notificationService) {
        super(mongoConnection);
        this.streamRuleService = streamRuleService;
        this.alertService = alertService;
        this.outputService = outputService;
        this.notificationService = notificationService;
    }

    public Stream load(ObjectId id) throws NotFoundException {
        DBObject o = this.get(StreamImpl.class, id);
        if (o == null) {
            throw new NotFoundException("Stream <" + id + "> not found!");
        }
        List<StreamRule> streamRules = this.streamRuleService.loadForStreamId(id.toHexString());
        Set<Output> outputs = this.loadOutputsForRawStream(o);
        return new StreamImpl((ObjectId)o.get("_id"), o.toMap(), streamRules, outputs);
    }

    @Override
    public Stream create(Map<String, Object> fields) {
        return new StreamImpl(fields);
    }

    @Override
    public Stream create(CreateStreamRequest cr, String userId) {
        HashMap streamData = Maps.newHashMap();
        streamData.put("title", cr.title());
        streamData.put("description", cr.description());
        streamData.put("creator_user_id", userId);
        streamData.put("created_at", Tools.iso8601());
        streamData.put("content_pack", cr.contentPack());
        return this.create(streamData);
    }

    @Override
    public Stream load(String id) throws NotFoundException {
        try {
            return this.load(new ObjectId(id));
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException("Stream <" + id + "> not found!");
        }
    }

    @Override
    public List<Stream> loadAllEnabled() {
        return this.loadAllEnabled(new HashMap<String, Object>());
    }

    public List<Stream> loadAllEnabled(Map<String, Object> additionalQueryOpts) {
        additionalQueryOpts.put("disabled", false);
        return this.loadAll(additionalQueryOpts);
    }

    @Override
    public List<Stream> loadAll() {
        return this.loadAll(new HashMap<String, Object>());
    }

    public List<Stream> loadAll(Map<String, Object> additionalQueryOpts) {
        ArrayList streams = Lists.newArrayList();
        BasicDBObject query = new BasicDBObject();
        for (Map.Entry<String, Object> o : additionalQueryOpts.entrySet()) {
            query.put(o.getKey(), o.getValue());
        }
        List<DBObject> results = this.query(StreamImpl.class, (DBObject)query);
        for (DBObject o : results) {
            String id = o.get("_id").toString();
            List<StreamRule> streamRules = null;
            try {
                streamRules = this.streamRuleService.loadForStreamId(id);
            }
            catch (NotFoundException e) {
                LOG.info("Exception while loading stream rules: " + e);
            }
            Set<Output> outputs = this.loadOutputsForRawStream(o);
            streams.add(new StreamImpl((ObjectId)o.get("_id"), o.toMap(), streamRules, outputs));
        }
        return streams;
    }

    @Override
    public List<Stream> loadAllWithConfiguredAlertConditions() {
        Map<String, BasicDBObject> queryOpts = Collections.singletonMap("alert_conditions", new BasicDBObject("$ne", Collections.emptyList()));
        return this.loadAll(queryOpts);
    }

    protected Set<Output> loadOutputsForRawStream(DBObject stream) {
        List outputIds = (List)stream.get("outputs");
        HashSet<Output> result = new HashSet<Output>();
        if (outputIds != null) {
            for (ObjectId outputId : outputIds) {
                try {
                    result.add(this.outputService.load(outputId.toHexString()));
                }
                catch (NotFoundException e) {
                    LOG.warn("Non-existing output <{}> referenced from stream <{}>!", (Object)outputId.toHexString(), stream.get("_id"));
                }
            }
        }
        return result;
    }

    @Override
    public long count() {
        return this.totalCount(StreamImpl.class);
    }

    @Override
    public void destroy(Stream stream) throws NotFoundException {
        for (StreamRule streamRule : this.streamRuleService.loadForStream(stream)) {
            super.destroy(streamRule);
        }
        for (Notification notification : this.notificationService.all()) {
            Object rawValue = notification.getDetail("stream_id");
            if (rawValue == null || !rawValue.toString().equals(stream.getId())) continue;
            LOG.debug("Removing notification that references stream: {}", (Object)notification);
            this.notificationService.destroy(notification);
        }
        super.destroy(stream);
    }

    public void update(Stream stream, String title, String description) throws ValidationException {
        if (title != null) {
            stream.getFields().put("title", title);
        }
        if (description != null) {
            stream.getFields().put("description", description);
        }
        this.save(stream);
    }

    @Override
    public void pause(Stream stream) throws ValidationException {
        stream.setDisabled(Boolean.valueOf(true));
        this.save(stream);
    }

    @Override
    public void resume(Stream stream) throws ValidationException {
        stream.setDisabled(Boolean.valueOf(false));
        this.save(stream);
    }

    @Override
    public List<StreamRule> getStreamRules(Stream stream) throws NotFoundException {
        return this.streamRuleService.loadForStream(stream);
    }

    @Override
    public List<AlertCondition> getAlertConditions(Stream stream) {
        ArrayList conditions = Lists.newArrayList();
        if (stream.getFields().containsKey("alert_conditions")) {
            for (BasicDBObject conditionFields : (List)stream.getFields().get("alert_conditions")) {
                try {
                    conditions.add(this.alertService.fromPersisted((Map<String, Object>)conditionFields, stream));
                }
                catch (AbstractAlertCondition.NoSuchAlertConditionTypeException e) {
                    LOG.error("Skipping unknown alert condition type.", (Throwable)e);
                }
                catch (Exception e) {
                    LOG.error("Skipping alert condition.", (Throwable)e);
                }
            }
        }
        return conditions;
    }

    @Override
    public AlertCondition getAlertCondition(Stream stream, String conditionId) throws NotFoundException {
        if (stream.getFields().containsKey("alert_conditions")) {
            for (BasicDBObject conditionFields : (List)stream.getFields().get("alert_conditions")) {
                try {
                    if (!conditionFields.get("id").equals(conditionId)) continue;
                    return this.alertService.fromPersisted((Map<String, Object>)conditionFields, stream);
                }
                catch (AbstractAlertCondition.NoSuchAlertConditionTypeException e) {
                    LOG.error("Skipping unknown alert condition type.", (Throwable)e);
                }
                catch (Exception e) {
                    LOG.error("Skipping alert condition.", (Throwable)e);
                }
            }
        }
        throw new NotFoundException();
    }

    @Override
    public void addAlertCondition(Stream stream, AlertCondition condition) throws ValidationException {
        this.embed(stream, "alert_conditions", (EmbeddedPersistable)condition);
    }

    @Override
    public void updateAlertCondition(Stream stream, AlertCondition condition) throws ValidationException {
        this.removeAlertCondition(stream, condition.getId());
        this.addAlertCondition(stream, condition);
    }

    @Override
    public void removeAlertCondition(Stream stream, String conditionId) {
        this.removeEmbedded(stream, "alert_conditions", conditionId);
    }

    @Override
    public void addAlertReceiver(Stream stream, String type, String name) {
        this.collection(stream).update((DBObject)new BasicDBObject("_id", (Object)new ObjectId(stream.getId())), (DBObject)new BasicDBObject("$push", (Object)new BasicDBObject("alert_receivers." + type, (Object)name)));
    }

    @Override
    public void removeAlertReceiver(Stream stream, String type, String name) {
        this.collection(stream).update((DBObject)new BasicDBObject("_id", (Object)new ObjectId(stream.getId())), (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("alert_receivers." + type, (Object)name)));
    }

    @Override
    public void addOutput(Stream stream, Output output) {
        this.collection(stream).update((DBObject)new BasicDBObject("_id", (Object)new ObjectId(stream.getId())), (DBObject)new BasicDBObject("$addToSet", (Object)new BasicDBObject("outputs", (Object)new ObjectId(output.getId()))));
    }

    @Override
    public void removeOutput(Stream stream, Output output) {
        this.collection(stream).update((DBObject)new BasicDBObject("_id", (Object)new ObjectId(stream.getId())), (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("outputs", (Object)new ObjectId(output.getId()))));
    }

    @Override
    public void removeOutputFromAllStreams(Output output) {
        ObjectId outputId = new ObjectId(output.getId());
        BasicDBObject match = new BasicDBObject("outputs", (Object)outputId);
        BasicDBObject modify = new BasicDBObject("$pull", (Object)new BasicDBObject("outputs", (Object)outputId));
        this.collection(StreamImpl.class).update((DBObject)match, (DBObject)modify, false, true);
    }
}

