/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UI {
    private static final String HELP_DOCS = "http://docs.graylog.org/";
    private static final String HELP_COMMUNITY = "https://www.graylog.org/community-support/";
    private static final String HELP_COMMERCIAL = "https://www.graylog.com/support/";
    private static final Logger LOG = LoggerFactory.getLogger(UI.class);

    public static void exitHardWithWall(String msg) {
        UI.exitHardWithWall(msg, new String[0]);
    }

    public static void exitHardWithWall(String msg, String ... docLinks) {
        LOG.error(UI.wallString(msg, docLinks));
        throw new IllegalStateException();
    }

    public static String wallString(String msg, String ... docLinks) {
        StringBuilder sb = new StringBuilder("\n");
        sb.append("\n").append(UI.wall("#")).append("\n");
        sb.append("ERROR: ").append(msg).append("\n\n");
        sb.append("Need help?").append("\n\n");
        sb.append("* Official documentation: ").append(HELP_DOCS).append("\n");
        sb.append("* Community support: ").append(HELP_COMMUNITY).append("\n");
        sb.append("* Commercial support: ").append(HELP_COMMERCIAL).append("\n");
        if (docLinks != null && docLinks.length > 0) {
            sb.append("\n").append("But we also got some specific help pages that might help you in this case:").append("\n\n");
            for (String docLink : docLinks) {
                sb.append("* ").append(docLink).append("\n");
            }
        }
        sb.append("\n").append("Terminating. :(").append("\n\n");
        sb.append(UI.wall("#"));
        return sb.toString();
    }

    private static String wall(String symbol) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 80; ++i) {
            sb.append(symbol);
        }
        return sb.append("\n").toString();
    }
}

