/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alarmcallbacks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationImpl;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.alarmcallbacks.requests.CreateAlarmCallbackRequest;

public class AlarmCallbackConfigurationServiceImpl
extends PersistedServiceImpl
implements AlarmCallbackConfigurationService {
    @Inject
    public AlarmCallbackConfigurationServiceImpl(MongoConnection mongoConnection) {
        super(mongoConnection);
    }

    @Override
    public List<AlarmCallbackConfiguration> getForStreamId(String streamId) {
        ArrayList alarmCallbackConfigurations = Lists.newArrayList();
        List<DBObject> respConfigurations = this.query(AlarmCallbackConfigurationImpl.class, (DBObject)new BasicDBObject("stream_id", (Object)streamId));
        for (DBObject configuration : respConfigurations) {
            alarmCallbackConfigurations.add(new AlarmCallbackConfigurationImpl((ObjectId)configuration.get("_id"), configuration.toMap()));
        }
        return alarmCallbackConfigurations;
    }

    @Override
    public List<AlarmCallbackConfiguration> getForStream(Stream stream) {
        return this.getForStreamId(stream.getId());
    }

    @Override
    public AlarmCallbackConfiguration load(String alarmCallbackId) {
        DBObject rawModel = this.get(AlarmCallbackConfigurationImpl.class, alarmCallbackId);
        return rawModel == null ? null : new AlarmCallbackConfigurationImpl((ObjectId)rawModel.get("_id"), rawModel.toMap());
    }

    @Override
    public AlarmCallbackConfiguration create(String streamId, CreateAlarmCallbackRequest request, String userId) {
        HashMap fields = Maps.newHashMap();
        fields.put("stream_id", new ObjectId(streamId));
        fields.put("type", request.type);
        fields.put("configuration", request.configuration);
        fields.put("created_at", Tools.iso8601());
        fields.put("creator_user_id", userId);
        return new AlarmCallbackConfigurationImpl(fields);
    }

    @Override
    public long count() {
        return this.count(AlarmCallbackConfigurationImpl.class, (DBObject)new BasicDBObject());
    }

    @Override
    public AlarmCallbackConfiguration update(String streamId, String alarmCallbackId, Map<String, Object> deltas) {
        return null;
    }

    @Override
    public String save(AlarmCallbackConfiguration model) throws ValidationException {
        return super.save(this.getImplOrFail(model));
    }

    @Override
    public int destroy(AlarmCallbackConfiguration model) {
        return super.destroy(this.getImplOrFail(model));
    }

    private AlarmCallbackConfigurationImpl getImplOrFail(AlarmCallbackConfiguration alarmCallback) {
        if (alarmCallback instanceof AlarmCallbackConfigurationImpl) {
            return (AlarmCallbackConfigurationImpl)alarmCallback;
        }
        throw new IllegalArgumentException("Argument must be of implementation class AlarmCallbackConfigurationImpl, not " + alarmCallback.getClass());
    }
}

