/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.graylog2.alerts.AlertSender;
import org.graylog2.alerts.MessageFormatter;
import org.graylog2.configuration.EmailConfiguration;
import org.graylog2.database.NotFoundException;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.database.users.User;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.users.UserService;
import org.graylog2.streams.StreamRuleService;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticEmailAlertSender
implements AlertSender {
    private static final Logger LOG = LoggerFactory.getLogger(StaticEmailAlertSender.class);
    private final StreamRuleService streamRuleService;
    protected final EmailConfiguration configuration;
    private final UserService userService;
    private final NotificationService notificationService;
    private final NodeId nodeId;
    private Configuration pluginConfig;

    @Inject
    public StaticEmailAlertSender(EmailConfiguration configuration, StreamRuleService streamRuleService, UserService userService, NotificationService notificationService, NodeId nodeId) {
        this.configuration = configuration;
        this.streamRuleService = streamRuleService;
        this.userService = userService;
        this.notificationService = notificationService;
        this.nodeId = nodeId;
    }

    @Override
    public void initialize(Configuration configuration) {
        this.pluginConfig = configuration;
    }

    @Override
    public void sendEmails(Stream stream, AlertCondition.CheckResult checkResult) throws TransportConfigurationException, EmailException {
        this.sendEmails(stream, checkResult, null);
    }

    private void sendEmail(String emailAddress, Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) throws TransportConfigurationException, EmailException {
        LOG.debug("Sending mail to " + emailAddress);
        if (!this.configuration.isEnabled()) {
            throw new TransportConfigurationException("Email transport is not enabled in server configuration file!");
        }
        SimpleEmail email = new SimpleEmail();
        if (Strings.isNullOrEmpty((String)this.configuration.getHostname())) {
            throw new TransportConfigurationException("No hostname configured for email transport while trying to send alert email!");
        }
        email.setHostName(this.configuration.getHostname());
        email.setSmtpPort(this.configuration.getPort());
        if (this.configuration.isUseSsl()) {
            email.setSslSmtpPort(Integer.toString(this.configuration.getPort()));
        }
        if (this.configuration.isUseAuth()) {
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(Strings.nullToEmpty((String)this.configuration.getUsername()), Strings.nullToEmpty((String)this.configuration.getPassword())));
        }
        email.setSSLOnConnect(this.configuration.isUseSsl());
        email.setStartTLSEnabled(this.configuration.isUseTls());
        if (this.pluginConfig != null && !Strings.isNullOrEmpty((String)this.pluginConfig.getString("sender"))) {
            email.setFrom(this.pluginConfig.getString("sender"));
        } else {
            email.setFrom(this.configuration.getFromEmail());
        }
        email.setSubject(this.buildSubject(stream, checkResult, backlog));
        email.setMsg(this.buildBody(stream, checkResult, backlog));
        email.addTo(emailAddress);
        email.send();
    }

    protected String buildSubject(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) {
        StringBuilder sb = new StringBuilder();
        String subjectPrefix = this.configuration.getSubjectPrefix();
        if (!Strings.isNullOrEmpty((String)subjectPrefix)) {
            sb.append(subjectPrefix).append(" ");
        }
        sb.append("Graylog alert for stream: ").append(stream.getTitle());
        return sb.toString();
    }

    protected String buildBody(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) {
        StringBuilder sb = new StringBuilder();
        sb.append(checkResult.getResultDescription());
        sb.append("\n\n");
        sb.append("##########\n");
        sb.append("Date: ").append(Tools.iso8601().toString()).append("\n");
        sb.append("Stream ID: ").append(stream.getId()).append("\n");
        sb.append("Stream title: ").append(stream.getTitle()).append("\n");
        sb.append("Stream URL: ").append(this.buildStreamDetailsURL(this.configuration.getWebInterfaceUri(), checkResult, stream)).append("\n");
        try {
            sb.append("Stream rules: ").append(this.streamRuleService.loadForStream(stream)).append("\n");
        }
        catch (NotFoundException e) {
            LOG.error("Unable to find stream rules for stream: " + stream.getId(), (Throwable)e);
        }
        sb.append("Alert triggered at: ").append(checkResult.getTriggeredAt()).append("\n");
        sb.append("Triggered condition: ").append(checkResult.getTriggeredCondition()).append("\n");
        sb.append("##########");
        if (backlog != null) {
            sb.append(this.buildBacklogSummary(backlog));
        }
        return sb.toString();
    }

    protected String buildStreamDetailsURL(URI baseUri, AlertCondition.CheckResult checkResult, Stream stream) {
        if (baseUri == null || Strings.isNullOrEmpty((String)baseUri.getHost())) {
            return "Please configure 'transport_email_web_interface_url' in your Graylog configuration file.";
        }
        int time = 5;
        if (checkResult.getTriggeredCondition().getParameters().get("time") != null) {
            time = (Integer)checkResult.getTriggeredCondition().getParameters().get("time");
        }
        DateTime dateAlertEnd = checkResult.getTriggeredAt();
        DateTime dateAlertStart = dateAlertEnd.minusMinutes(time);
        String alertStart = Tools.getISO8601String((DateTime)dateAlertStart);
        String alertEnd = Tools.getISO8601String((DateTime)dateAlertEnd);
        return baseUri + "/streams/" + stream.getId() + "/messages?rangetype=absolute&from=" + alertStart + "&to=" + alertEnd + "&q=*";
    }

    protected String buildBacklogSummary(List<Message> backlog) {
        if (backlog == null || backlog.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        MessageFormatter messageFormatter = new MessageFormatter();
        sb.append("\n\nLast ");
        if (backlog.size() > 1) {
            sb.append(backlog.size()).append(" relevant messages:\n");
        } else {
            sb.append("relevant message:\n");
        }
        sb.append("======================\n\n");
        for (Message message : backlog) {
            sb.append(messageFormatter.formatForMail(message));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void sendEmails(Stream stream, AlertCondition.CheckResult checkResult, List<Message> backlog) throws TransportConfigurationException, EmailException {
        if (!this.configuration.isEnabled()) {
            throw new TransportConfigurationException("Email transport is not enabled in server configuration file!");
        }
        if (stream.getAlertReceivers() == null || stream.getAlertReceivers().isEmpty()) {
            throw new RuntimeException("Stream [" + stream + "] has no alert receivers.");
        }
        ArrayList recipients = Lists.newArrayList();
        if (stream.getAlertReceivers().get("users") != null) {
            for (String username : (List)stream.getAlertReceivers().get("users")) {
                User user = this.userService.load(username);
                if (user == null || user.getEmail() == null || user.getEmail().isEmpty()) continue;
                recipients.add(user.getEmail());
            }
        }
        if (stream.getAlertReceivers().get("emails") != null) {
            for (String email : (List)stream.getAlertReceivers().get("emails")) {
                if (email.isEmpty()) continue;
                recipients.add(email);
            }
        }
        if (recipients.size() == 0) {
            Notification notification = this.notificationService.buildNow().addNode(this.nodeId.toString()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.NORMAL).addDetail("title", "Stream \"" + stream.getTitle() + "\" is alerted, but no recipients have been defined!").addDetail("description", "To fix this, go to the alerting configuration of the stream and add at least one alert recipient.");
            this.notificationService.publishIfFirst(notification);
        }
        for (String email : recipients) {
            this.sendEmail(email, stream, checkResult, backlog);
        }
    }
}

