/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts.types;

import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.indexer.InvalidRangeFormatException;
import org.graylog2.indexer.results.CountResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.SearchResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCountAlertCondition
extends AbstractAlertCondition {
    private static final Logger LOG = LoggerFactory.getLogger(MessageCountAlertCondition.class);
    private final int time;
    private final ThresholdType thresholdType;
    private final int threshold;
    private List<Message> searchHits = Collections.emptyList();
    private final Searches searches;

    @AssistedInject
    public MessageCountAlertCondition(Searches searches, @Assisted Stream stream, @Nullable @Assisted String id, @Assisted DateTime createdAt, @Assisted(value="userid") String creatorUserId, @Assisted Map<String, Object> parameters) {
        super(stream, id, AbstractAlertCondition.Type.MESSAGE_COUNT, createdAt, creatorUserId, parameters);
        this.searches = searches;
        this.time = (Integer)parameters.get("time");
        this.thresholdType = ThresholdType.valueOf(((String)parameters.get("threshold_type")).toUpperCase());
        this.threshold = (Integer)parameters.get("threshold");
    }

    public String getDescription() {
        return "time: " + this.time + ", threshold_type: " + this.thresholdType.toString().toLowerCase() + ", threshold: " + this.threshold + ", grace: " + this.grace;
    }

    @Override
    protected AbstractAlertCondition.CheckResult runCheck() {
        try {
            boolean triggered;
            String filter = "streams:" + this.stream.getId();
            CountResult result = this.searches.count("*", new RelativeRange(this.time * 60), filter);
            long count = result.getCount();
            LOG.debug("Alert check <{}> result: [{}]", (Object)this.id, (Object)count);
            switch (this.thresholdType) {
                case MORE: {
                    triggered = count > (long)this.threshold;
                    break;
                }
                case LESS: {
                    triggered = count < (long)this.threshold;
                    break;
                }
                default: {
                    triggered = false;
                }
            }
            if (triggered) {
                ArrayList summaries = Lists.newArrayList();
                if (this.getBacklog() > 0) {
                    SearchResult backlogResult = this.searches.search("*", filter, new RelativeRange(this.time * 60), this.getBacklog(), 0, new Sorting("timestamp", Sorting.Direction.DESC));
                    for (ResultMessage resultMessage : backlogResult.getResults()) {
                        Message msg = new Message(resultMessage.getMessage());
                        summaries.add(new MessageSummary(resultMessage.getIndex(), msg));
                    }
                }
                String resultDescription = "Stream had " + count + " messages in the last " + this.time + " minutes with trigger condition " + this.thresholdType.toString().toLowerCase() + " than " + this.threshold + " messages. " + "(Current grace time: " + this.grace + " minutes)";
                return new AbstractAlertCondition.CheckResult(true, this, resultDescription, Tools.iso8601(), summaries);
            }
            return new AbstractAlertCondition.NegativeCheckResult(this);
        }
        catch (InvalidRangeParametersException e) {
            LOG.error("Invalid timerange.", (Throwable)e);
            return null;
        }
        catch (InvalidRangeFormatException e) {
            LOG.error("Invalid timerange format.", (Throwable)e);
            return null;
        }
    }

    public static interface Factory {
        public MessageCountAlertCondition createAlertCondition(Stream var1, String var2, DateTime var3, @Assisted(value="userid") String var4, Map<String, Object> var5);
    }

    public static enum ThresholdType {
        MORE,
        LESS;

    }
}

