/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.plugin.Tools;

public class DeflectorInformation {
    private final Cluster cluster;
    private Map<String, IndexStats> indices = Maps.newHashMap();
    private String deflectorTarget;
    private int maxMessagesPerIndex;
    private String serverId;

    public DeflectorInformation(Cluster cluster) {
        this.cluster = cluster;
    }

    public void addIndex(IndexStats index) {
        this.indices.put(index.getIndex(), index);
    }

    public void addIndices(Map<String, IndexStats> indices) {
        this.indices.putAll(indices);
    }

    public void setDeflectorTarget(String target) {
        this.deflectorTarget = target;
    }

    public void setConfiguredMaximumMessagesPerIndex(int max) {
        this.maxMessagesPerIndex = max;
    }

    public void setCallingNode(String serverId) {
        this.serverId = serverId;
    }

    public Map<String, Object> getAsDatabaseObject() {
        HashMap result = Maps.newHashMap();
        HashMap indexInformation = Maps.newHashMap();
        for (Map.Entry<String, IndexStats> e : this.indices.entrySet()) {
            indexInformation.put(e.getKey(), this.getIndexInformation(e.getValue()));
        }
        result.put("server_id", this.serverId);
        result.put("deflector_target", this.deflectorTarget);
        result.put("max_messages_per_index", this.maxMessagesPerIndex);
        result.put("indices", indexInformation);
        result.put("timestamp", Tools.getUTCTimestamp());
        return result;
    }

    private Map<String, Object> getIndexInformation(IndexStats stats) {
        HashMap info = Maps.newHashMap();
        info.put("docs", stats.getPrimaries().getDocs().getCount());
        info.put("size", stats.getPrimaries().getStore().getSize().getKb());
        info.put("time_index", stats.getPrimaries().getIndexing().getTotal().getIndexTime().getSeconds());
        info.put("time_query", stats.getPrimaries().getSearch().getTotal().getQueryTime().getSeconds());
        info.put("time_fetch", stats.getPrimaries().getSearch().getTotal().getFetchTime().getSeconds());
        info.put("time_get", stats.getPrimaries().getGet().getTime().getSeconds());
        info.put("shards", this.getShardInformation(stats));
        return info;
    }

    private List<Map<String, Object>> getShardInformation(IndexStats stats) {
        ArrayList shards = Lists.newArrayList();
        for (Map.Entry s : stats.getIndexShards().entrySet()) {
            for (ShardStats ss : (IndexShardStats)s.getValue()) {
                HashMap shard = Maps.newHashMap();
                shard.put("node_hostname", this.cluster.nodeIdToHostName(ss.getShardRouting().currentNodeId()));
                shard.put("node_name", this.cluster.nodeIdToName(ss.getShardRouting().currentNodeId()));
                shard.put("id", ss.getShardId());
                shard.put("node_id", ss.getShardRouting().currentNodeId());
                shard.put("primary", ss.getShardRouting().primary());
                shard.put("is_initializing", ss.getShardRouting().initializing());
                shard.put("is_started", ss.getShardRouting().started());
                shard.put("is_unassigned", ss.getShardRouting().unassigned());
                shard.put("is_relocating", ss.getShardRouting().relocating());
                shard.put("relocating_to", this.cluster.nodeIdToName(ss.getShardRouting().relocatingNodeId()));
                shards.add(shard);
            }
        }
        return shards;
    }
}

