/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.InvalidRangeFormatException;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.searches.timeranges.RelativeRange;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHelper {
    private static final Logger LOG = LoggerFactory.getLogger(IndexHelper.class);

    public static Set<String> getOldestIndices(Set<String> indexNames, int count) {
        HashSet r = Sets.newHashSet();
        if (count < 0 || indexNames.size() <= count) {
            return r;
        }
        HashSet numbers = Sets.newHashSet();
        for (String indexName : indexNames) {
            numbers.add(Deflector.extractIndexNumber(indexName));
        }
        List<String> sorted = IndexHelper.prependPrefixes(IndexHelper.getPrefix(indexNames), Tools.asSortedList((Collection)numbers));
        r.addAll(sorted.subList(0, count));
        return r;
    }

    public static FilterBuilder getTimestampRangeFilter(TimeRange range) throws InvalidRangeFormatException {
        if (range == null) {
            return null;
        }
        return FilterBuilders.rangeFilter((String)"timestamp").gte((Object)Tools.buildElasticSearchTimeFormat((DateTime)range.getFrom())).lte((Object)Tools.buildElasticSearchTimeFormat((DateTime)range.getTo()));
    }

    private static String getPrefix(Set<String> names) {
        if (names.isEmpty()) {
            return "";
        }
        String name = (String)names.toArray()[0];
        return name.substring(0, name.lastIndexOf("_"));
    }

    private static List<String> prependPrefixes(String prefix, List<Integer> numbers) {
        ArrayList r = Lists.newArrayList();
        for (int number : numbers) {
            r.add(prefix + "_" + number);
        }
        return r;
    }

    public static Set<String> determineAffectedIndices(IndexRangeService indexRangeService, Deflector deflector, TimeRange range) {
        HashSet indices = Sets.newHashSet();
        for (IndexRange indexRange : indexRangeService.getFrom((int)(range.getFrom().getMillis() / 1000L))) {
            indices.add(indexRange.getIndexName());
        }
        if (indices.isEmpty() || range instanceof RelativeRange) {
            indices.add(deflector.getCurrentActualTargetIndex());
        }
        return indices;
    }

    public static Set<IndexRange> determineAffectedIndicesWithRanges(IndexRangeService indexRangeService, Deflector deflector, TimeRange range) {
        TreeSet indices = Sets.newTreeSet((Comparator)new Comparator<IndexRange>(){

            @Override
            public int compare(IndexRange o1, IndexRange o2) {
                return o2.getStart().compareTo((ReadableInstant)o1.getStart());
            }
        });
        for (IndexRange indexRange : indexRangeService.getFrom((int)(range.getFrom().getMillis() / 1000L))) {
            indices.add(indexRange);
        }
        if (indices.isEmpty() || range instanceof RelativeRange) {
            try {
                IndexRange deflectorIndexRange = indexRangeService.get(deflector.getCurrentActualTargetIndex());
                indices.add(deflectorIndexRange);
            }
            catch (NotFoundException e) {
                LOG.warn("Couldn't find latest deflector target index", (Throwable)e);
            }
        }
        return indices;
    }
}

