/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.ranges;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Map;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.EmptyIndexException;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.ranges.RebuildIndexRangesJob;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateNewSingleIndexRangeJob
extends RebuildIndexRangesJob {
    private static final Logger LOG = LoggerFactory.getLogger(CreateNewSingleIndexRangeJob.class);
    private final String indexName;

    @AssistedInject
    public CreateNewSingleIndexRangeJob(@Assisted Deflector deflector, @Assisted String indexName, Searches searches, ActivityWriter activityWriter, IndexRangeService indexRangeService) {
        super(deflector, searches, activityWriter, indexRangeService);
        this.indexName = indexName;
    }

    @Override
    public String getDescription() {
        return "Creates new single index range information.";
    }

    @Override
    public String getInfo() {
        return "Calculating ranges for index " + this.indexName + ".";
    }

    @Override
    public void execute() {
        LOG.info("Calculating ranges for index {}.", (Object)this.indexName);
        try {
            Map<String, Object> range = this.deflector.getCurrentActualTargetIndex().equals(this.indexName) ? this.calculateRange(this.indexName) : this.getDeflectorIndexRange(this.indexName);
            IndexRange indexRange = this.indexRangeService.create(range);
            this.indexRangeService.destroy(this.indexName);
            this.indexRangeService.save(indexRange);
            LOG.info("Created ranges for index {}.", (Object)this.indexName);
        }
        catch (EmptyIndexException e) {
            LOG.error("Unable to calculate ranges for index {}: {}", (Object)this.indexName, (Object)e);
        }
        catch (ValidationException e) {
            LOG.error("Unable to save index range for index {}: {}", (Object)this.indexName, (Object)e);
        }
        catch (Exception e) {
            LOG.error("Exception during index range calculation for index {}: ", (Object)this.indexName, (Object)e);
        }
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public int maxConcurrency() {
        return Integer.MAX_VALUE;
    }

    public static interface Factory {
        public CreateNewSingleIndexRangeJob create(Deflector var1, String var2);
    }
}

