/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.ranges;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeImpl;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRangeServiceImpl
extends PersistedServiceImpl
implements IndexRangeService {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRangeServiceImpl.class);
    private final ActivityWriter activityWriter;

    @Inject
    public IndexRangeServiceImpl(MongoConnection mongoConnection, ActivityWriter activityWriter) {
        super(mongoConnection);
        this.activityWriter = activityWriter;
    }

    @Override
    public IndexRange get(String index) throws NotFoundException {
        DBObject dbo = this.findOne(IndexRangeImpl.class, (DBObject)new BasicDBObject("index", (Object)index));
        if (dbo == null) {
            throw new NotFoundException("Index " + index + " not found.");
        }
        return new IndexRangeImpl((ObjectId)dbo.get("_id"), dbo.toMap());
    }

    @Override
    public List<IndexRange> getFrom(int timestamp) {
        ArrayList ranges = Lists.newArrayList();
        BasicDBObject query = new BasicDBObject();
        query.put("start", (Object)new BasicDBObject("$gte", (Object)timestamp));
        for (DBObject dbo : this.query(IndexRangeImpl.class, (DBObject)query)) {
            ranges.add(new IndexRangeImpl((ObjectId)dbo.get("_id"), dbo.toMap()));
        }
        Collections.sort(ranges, new Comparator<IndexRange>(){

            @Override
            public int compare(IndexRange o1, IndexRange o2) {
                return o2.getStart().compareTo((ReadableInstant)o1.getStart());
            }
        });
        return ranges;
    }

    @Override
    public void destroy(String index) {
        try {
            IndexRange range = this.get(index);
            this.destroy(range);
        }
        catch (NotFoundException e) {
            return;
        }
        String x = "Removed range meta-information of [" + index + "]";
        LOG.info(x);
        this.activityWriter.write(new Activity(x, IndexRangeImpl.class));
    }

    @Override
    public IndexRange create(Map<String, Object> range) {
        return new IndexRangeImpl(range);
    }

    @Override
    public void destroyAll() {
        this.destroyAll(IndexRangeImpl.class);
    }
}

