/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.metrics.stats.Stats;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadablePeriod;

public class FieldHistogramResult
extends HistogramResult {
    private static final Map<String, Number> EMPTY_RESULT = ImmutableMap.builder().put((Object)"count", (Object)0).put((Object)"min", (Object)0).put((Object)"max", (Object)0).put((Object)"total", (Object)0).put((Object)"total_count", (Object)0).put((Object)"mean", (Object)0).build();
    private final DateHistogram result;
    private final Searches.DateHistogramInterval interval;

    public FieldHistogramResult(DateHistogram result, String originalQuery, BytesReference builtQuery, Searches.DateHistogramInterval interval, TimeValue took) {
        super(originalQuery, builtQuery, took);
        this.result = result;
        this.interval = interval;
    }

    @Override
    public Searches.DateHistogramInterval getInterval() {
        return this.interval;
    }

    @Override
    public Map<Long, Map<String, Number>> getResults() {
        TreeMap results = Maps.newTreeMap();
        long minTimestamp = Long.MAX_VALUE;
        long maxTimestamp = Long.MIN_VALUE;
        for (DateHistogram.Bucket b : this.result.getBuckets()) {
            HashMap resultMap = Maps.newHashMap();
            resultMap.put("total_count", b.getDocCount());
            Stats stats = (Stats)b.getAggregations().get("gl2_stats");
            resultMap.put("count", stats.getCount());
            resultMap.put("min", stats.getMin());
            resultMap.put("max", stats.getMax());
            resultMap.put("total", stats.getSum());
            resultMap.put("mean", stats.getAvg());
            long timestamp = b.getKeyAsDate().getMillis() / 1000L;
            if (timestamp < minTimestamp) {
                minTimestamp = timestamp;
            }
            if (timestamp > maxTimestamp) {
                maxTimestamp = timestamp;
            }
            results.put(timestamp, resultMap);
        }
        MutableDateTime currentTime = new MutableDateTime(minTimestamp);
        while (currentTime.getMillis() < maxTimestamp) {
            Map entry = (Map)results.get(currentTime.getMillis());
            currentTime.add((ReadablePeriod)this.interval.getPeriod());
            if (entry != null) continue;
            results.put(currentTime.getMillis(), EMPTY_RESULT);
        }
        return results;
    }
}

