/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import java.util.List;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStats;
import org.graylog2.indexer.results.IndexQueryResult;
import org.graylog2.indexer.results.ResultMessage;

public class FieldStatsResult
extends IndexQueryResult {
    private final long count;
    private final double sum;
    private final double sumOfSquares;
    private final double mean;
    private final double min;
    private final double max;
    private final double variance;
    private final double stdDeviation;
    private List<ResultMessage> searchHits;

    public FieldStatsResult(ExtendedStats f, String originalQuery, BytesReference builtQuery, TimeValue took) {
        super(originalQuery, builtQuery, took);
        this.count = f.getCount();
        this.sum = f.getSum();
        this.sumOfSquares = f.getSumOfSquares();
        this.mean = f.getAvg();
        this.min = f.getMin();
        this.max = f.getMax();
        this.variance = f.getVariance();
        this.stdDeviation = f.getStdDeviation();
    }

    public FieldStatsResult(ExtendedStats facet, SearchHits searchHits, String query, BytesReference source, TimeValue took) {
        this(facet, query, source, took);
        this.searchHits = this.buildResults(searchHits);
    }

    public long getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    public double getMean() {
        return this.mean;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getVariance() {
        return this.variance;
    }

    public double getStdDeviation() {
        return this.stdDeviation;
    }

    public List<ResultMessage> getSearchHits() {
        return this.searchHits;
    }
}

