/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation;

import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TimeBasedRotationStrategy
implements RotationStrategy {
    private static final Logger log = LoggerFactory.getLogger(TimeBasedRotationStrategy.class);
    private final Period rotationPeriod;
    private DateTime lastRotation;
    private DateTime anchor;

    @Inject
    public TimeBasedRotationStrategy(ElasticsearchConfiguration configuration) {
        this(configuration.getMaxTimePerIndex());
    }

    public TimeBasedRotationStrategy(Period rotationPeriod) {
        this.rotationPeriod = rotationPeriod.normalizedStandard();
        this.anchor = TimeBasedRotationStrategy.determineRotationPeriodAnchor(rotationPeriod);
        this.lastRotation = null;
    }

    protected static DateTime determineRotationPeriodAnchor(Period period) {
        Period normalized = period.normalizedStandard();
        int years = normalized.getYears();
        int months = normalized.getMonths();
        int weeks = normalized.getWeeks();
        int days = normalized.getDays();
        int hours = normalized.getHours();
        int minutes = normalized.getMinutes();
        int seconds = normalized.getSeconds();
        if (years == 0 && months == 0 && weeks == 0 && days == 0 && hours == 0 && minutes == 0 && seconds == 0) {
            throw new IllegalArgumentException("Invalid rotation period specified");
        }
        DateTimeFieldType largestStrideType = null;
        if (seconds > 0) {
            largestStrideType = DateTimeFieldType.secondOfMinute();
        }
        if (minutes > 0) {
            largestStrideType = DateTimeFieldType.minuteOfHour();
        }
        if (hours > 0) {
            largestStrideType = DateTimeFieldType.hourOfDay();
        }
        if (days > 0) {
            largestStrideType = DateTimeFieldType.dayOfMonth();
        }
        if (weeks > 0) {
            largestStrideType = DateTimeFieldType.weekOfWeekyear();
        }
        if (months > 0) {
            largestStrideType = DateTimeFieldType.monthOfYear();
        }
        if (years > 0) {
            largestStrideType = DateTimeFieldType.year();
        }
        if (largestStrideType == null) {
            throw new IllegalArgumentException("Could not determine rotation stride length.");
        }
        DateTime now = Tools.iso8601();
        DateTimeField field = largestStrideType.getField(now.getChronology());
        int periodValue = normalized.get(largestStrideType.getDurationType());
        long fieldValue = field.roundFloor(now.getMillis());
        int fieldValueInUnit = field.get(fieldValue);
        if (periodValue == 0) {
            log.warn("Determining stride length failed because of a 0 period. Defaulting back to 1 period to avoid crashing, but this is a bug!");
            periodValue = 1;
        }
        long difference = fieldValueInUnit % periodValue;
        long newValue = field.add(fieldValue, -1L * difference);
        return new DateTime(newValue, DateTimeZone.UTC);
    }

    @Nonnull
    public RotationStrategy.Result shouldRotate(String ignored) {
        DateTime tmpAnchor;
        DateTime now = Tools.iso8601();
        if (this.lastRotation == null) {
            this.lastRotation = now;
            this.anchor = TimeBasedRotationStrategy.determineRotationPeriodAnchor(this.rotationPeriod);
            return new SimpleResult(true, "No known previous rotation time, forcing index rotation now.");
        }
        DateTime nextRotation = this.anchor.plus((ReadablePeriod)this.rotationPeriod);
        if (nextRotation.isAfter((ReadableInstant)now)) {
            return new SimpleResult(false, MessageFormat.format("Next rotation at {0}", nextRotation));
        }
        int multiplicator = 0;
        while ((tmpAnchor = this.anchor.withPeriodAdded((ReadablePeriod)this.rotationPeriod, ++multiplicator)).isBefore((ReadableInstant)now)) {
        }
        this.anchor = this.anchor.withPeriodAdded((ReadablePeriod)this.rotationPeriod, multiplicator - 1);
        this.lastRotation = now;
        return new SimpleResult(true, MessageFormat.format("Rotation period {0} elapsed, next rotation at {1}", this.rotationPeriod, this.anchor));
    }

    private static class SimpleResult
    implements RotationStrategy.Result {
        private final String message;
        private final boolean rotate;

        public SimpleResult(boolean rotate, String message) {
            this.message = message;
            this.rotate = rotate;
            log.debug("{} because of: {}", (Object)(rotate ? "Rotating" : "Not rotating"), (Object)message);
        }

        public String getDescription() {
            return this.message;
        }

        public boolean shouldRotate() {
            return this.rotate;
        }
    }
}

