/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.query.BoolFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.missing.Missing;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStats;
import org.elasticsearch.search.sort.SortOrder;
import org.graylog2.Configuration;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.IndexHelper;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.results.CountResult;
import org.graylog2.indexer.results.DateHistogramResult;
import org.graylog2.indexer.results.FieldHistogramResult;
import org.graylog2.indexer.results.FieldStatsResult;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.results.SearchResult;
import org.graylog2.indexer.results.TermsResult;
import org.graylog2.indexer.results.TermsStatsResult;
import org.graylog2.indexer.searches.SearchesConfig;
import org.graylog2.indexer.searches.SearchesConfigBuilder;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.graylog2.indexer.searches.timeranges.TimeRanges;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Searches {
    private static final Logger LOG = LoggerFactory.getLogger(Searches.class);
    public static final String AGG_TERMS = "gl2_terms";
    public static final String AGG_STATS = "gl2_stats";
    public static final String AGG_TERMS_STATS = "gl2_termsstats";
    public static final String AGG_FILTER = "gl2_filter";
    public static final String AGG_HISTOGRAM = "gl2_histogram";
    public static final String AGG_EXTENDED_STATS = "gl2_extended_stats";
    private final Configuration configuration;
    private final Deflector deflector;
    private final IndexRangeService indexRangeService;
    private final Client c;
    private final MetricRegistry metricRegistry;
    private final Timer esRequestTimer;
    private final Histogram esTimeRangeHistogram;

    @Inject
    public Searches(Configuration configuration, Deflector deflector, IndexRangeService indexRangeService, Client client, MetricRegistry metricRegistry) {
        this.configuration = (Configuration)((Object)Preconditions.checkNotNull((Object)((Object)configuration)));
        this.deflector = (Deflector)Preconditions.checkNotNull((Object)deflector);
        this.indexRangeService = (IndexRangeService)Preconditions.checkNotNull((Object)indexRangeService);
        this.c = (Client)Preconditions.checkNotNull((Object)client);
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
        this.esRequestTimer = metricRegistry.timer(MetricRegistry.name(Searches.class, (String[])new String[]{"elasticsearch", "requests"}));
        this.esTimeRangeHistogram = metricRegistry.histogram(MetricRegistry.name(Searches.class, (String[])new String[]{"elasticsearch", "ranges"}));
    }

    public CountResult count(String query, TimeRange range) {
        return this.count(query, range, null);
    }

    public CountResult count(String query, TimeRange range, String filter) {
        Set<String> indices = IndexHelper.determineAffectedIndices(this.indexRangeService, this.deflector, range);
        SearchRequest request = filter == null ? this.standardSearchRequest(query, indices, range).request() : this.filteredSearchRequest(query, filter, indices, range).request();
        request.searchType(SearchType.COUNT);
        SearchResponse r = (SearchResponse)this.c.search(request).actionGet();
        this.esRequestTimer.update(r.getTookInMillis(), TimeUnit.MILLISECONDS);
        return new CountResult(r.getHits().getTotalHits(), r.getTookInMillis(), r.getHits());
    }

    public ScrollResult scroll(String query, TimeRange range, int limit, int offset, List<String> fields, String filter) {
        Set<String> indices = IndexHelper.determineAffectedIndices(this.indexRangeService, this.deflector, range);
        SearchRequestBuilder srb = this.standardSearchRequest(query, indices, limit, offset, range, null, false);
        if (range != null && filter != null) {
            srb.setPostFilter((FilterBuilder)this.standardFilters(range, filter));
        }
        srb.addFields(fields.toArray(new String[fields.size()]));
        srb.addField("_source");
        SearchRequest request = srb.setSearchType(SearchType.SCAN).setScroll(new TimeValue(1L, TimeUnit.MINUTES)).setSize(500).request();
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("ElasticSearch scroll query: {}", (Object)XContentHelper.convertToJson((BytesReference)request.source(), (boolean)false));
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        SearchResponse r = (SearchResponse)this.c.search(request).actionGet();
        this.esRequestTimer.update(r.getTookInMillis(), TimeUnit.MILLISECONDS);
        return new ScrollResult(this.c, query, request.source(), r, fields);
    }

    public SearchResult search(String query, TimeRange range, int limit, int offset, Sorting sorting) {
        return this.search(query, null, range, limit, offset, sorting);
    }

    public SearchResult search(String query, String filter, TimeRange range, int limit, int offset, Sorting sorting) {
        SearchesConfig searchesConfig = SearchesConfigBuilder.newConfig().setQuery(query).setFilter(filter).setRange(range).setLimit(limit).setOffset(offset).setSorting(sorting).build();
        return this.search(searchesConfig);
    }

    public SearchResult search(SearchesConfig config) {
        Set<IndexRange> indices = IndexHelper.determineAffectedIndicesWithRanges(this.indexRangeService, this.deflector, config.range());
        HashSet indexNames = Sets.newHashSet();
        for (IndexRange index : indices) {
            indexNames.add(index.getIndexName());
        }
        SearchRequest request = this.searchRequest(config, indexNames).request();
        SearchResponse r = (SearchResponse)this.c.search(request).actionGet();
        this.esRequestTimer.update(r.getTookInMillis(), TimeUnit.MILLISECONDS);
        return new SearchResult(r.getHits(), indices, config.query(), request.source(), r.getTook());
    }

    public TermsResult terms(String field, int size, String query, String filter, TimeRange range) {
        if (size == 0) {
            size = 50;
        }
        SearchRequestBuilder srb = filter == null ? this.standardSearchRequest(query, IndexHelper.determineAffectedIndices(this.indexRangeService, this.deflector, range), range) : this.filteredSearchRequest(query, filter, IndexHelper.determineAffectedIndices(this.indexRangeService, this.deflector, range), range);
        FilterAggregationBuilder builder = ((FilterAggregationBuilder)((FilterAggregationBuilder)AggregationBuilders.filter((String)AGG_FILTER).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)AGG_TERMS).field(field)).size(size))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.missing((String)"missing").field(field))).filter((FilterBuilder)this.standardFilters(range, filter));
        srb.addAggregation((AbstractAggregationBuilder)builder);
        SearchRequest request = srb.request();
        SearchResponse r = (SearchResponse)this.c.search(request).actionGet();
        this.esRequestTimer.update(r.getTookInMillis(), TimeUnit.MILLISECONDS);
        Filter f = (Filter)r.getAggregations().get(AGG_FILTER);
        return new TermsResult((Terms)f.getAggregations().get(AGG_TERMS), (Missing)f.getAggregations().get("missing"), f.getDocCount(), query, request.source(), r.getTook());
    }

    public TermsResult terms(String field, int size, String query, TimeRange range) {
        return this.terms(field, size, query, null, range);
    }

    public TermsStatsResult termsStats(String keyField, String valueField, TermsStatsOrder order, int size, String query, String filter, TimeRange range) {
        Terms.Order termsOrder;
        if (size == 0) {
            size = 50;
        }
        SearchRequestBuilder srb = filter == null ? this.standardSearchRequest(query, IndexHelper.determineAffectedIndices(this.indexRangeService, this.deflector, range), range) : this.filteredSearchRequest(query, filter, IndexHelper.determineAffectedIndices(this.indexRangeService, this.deflector, range), range);
        switch (order) {
            case COUNT: {
                termsOrder = Terms.Order.count((boolean)true);
                break;
            }
            case REVERSE_COUNT: {
                termsOrder = Terms.Order.count((boolean)false);
                break;
            }
            case TERM: {
                termsOrder = Terms.Order.term((boolean)true);
                break;
            }
            case REVERSE_TERM: {
                termsOrder = Terms.Order.term((boolean)false);
                break;
            }
            case MIN: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"min", (boolean)true);
                break;
            }
            case REVERSE_MIN: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"min", (boolean)false);
                break;
            }
            case MAX: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"max", (boolean)true);
                break;
            }
            case REVERSE_MAX: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"max", (boolean)false);
                break;
            }
            case MEAN: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"avg", (boolean)true);
                break;
            }
            case REVERSE_MEAN: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"avg", (boolean)false);
                break;
            }
            case TOTAL: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"sum", (boolean)true);
                break;
            }
            case REVERSE_TOTAL: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"sum", (boolean)false);
                break;
            }
            default: {
                termsOrder = Terms.Order.count((boolean)true);
            }
        }
        FilterAggregationBuilder builder = ((FilterAggregationBuilder)AggregationBuilders.filter((String)AGG_FILTER).subAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)AGG_TERMS_STATS).field(keyField)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.stats((String)AGG_STATS).field(valueField))).order(termsOrder).size(size))).filter((FilterBuilder)this.standardFilters(range, filter));
        srb.addAggregation((AbstractAggregationBuilder)builder);
        SearchRequest request = srb.request();
        SearchResponse r = (SearchResponse)this.c.search(request).actionGet();
        this.esRequestTimer.update(r.getTookInMillis(), TimeUnit.MILLISECONDS);
        Filter f = (Filter)r.getAggregations().get(AGG_FILTER);
        return new TermsStatsResult((Terms)f.getAggregations().get(AGG_TERMS_STATS), query, request.source(), r.getTook());
    }

    public TermsStatsResult termsStats(String keyField, String valueField, TermsStatsOrder order, int size, String query, TimeRange range) {
        return this.termsStats(keyField, valueField, order, size, query, null, range);
    }

    public FieldStatsResult fieldStats(String field, String query, TimeRange range) throws FieldTypeException {
        return this.fieldStats(field, query, null, range);
    }

    public FieldStatsResult fieldStats(String field, String query, String filter, TimeRange range) throws FieldTypeException {
        SearchResponse r;
        SearchRequest request;
        SearchRequestBuilder srb = filter == null ? this.standardSearchRequest(query, IndexHelper.determineAffectedIndices(this.indexRangeService, this.deflector, range), range) : this.filteredSearchRequest(query, filter, IndexHelper.determineAffectedIndices(this.indexRangeService, this.deflector, range), range);
        FilterAggregationBuilder builder = (FilterAggregationBuilder)AggregationBuilders.filter((String)AGG_FILTER).filter((FilterBuilder)this.standardFilters(range, filter)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.extendedStats((String)AGG_EXTENDED_STATS).field(field));
        srb.addAggregation((AbstractAggregationBuilder)builder);
        try {
            request = srb.request();
            r = (SearchResponse)this.c.search(request).actionGet();
        }
        catch (SearchPhaseExecutionException e) {
            throw new FieldTypeException(e);
        }
        this.esRequestTimer.update(r.getTookInMillis(), TimeUnit.MILLISECONDS);
        Filter f = (Filter)r.getAggregations().get(AGG_FILTER);
        return new FieldStatsResult((ExtendedStats)f.getAggregations().get(AGG_EXTENDED_STATS), r.getHits(), query, request.source(), r.getTook());
    }

    public HistogramResult histogram(String query, DateHistogramInterval interval, TimeRange range) {
        return this.histogram(query, interval, null, range);
    }

    public HistogramResult histogram(String query, DateHistogramInterval interval, String filter, TimeRange range) {
        FilterAggregationBuilder builder = ((FilterAggregationBuilder)AggregationBuilders.filter((String)AGG_FILTER).subAggregation((AbstractAggregationBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)AGG_HISTOGRAM).field("timestamp")).interval(interval.toESInterval()))).filter((FilterBuilder)this.standardFilters(range, filter));
        QueryStringQueryBuilder qs = QueryBuilders.queryStringQuery((String)query);
        qs.allowLeadingWildcard(this.configuration.isAllowLeadingWildcardSearches());
        SearchRequestBuilder srb = this.c.prepareSearch(new String[0]);
        Set<String> affectedIndices = IndexHelper.determineAffectedIndices(this.indexRangeService, this.deflector, range);
        srb.setIndices(affectedIndices.toArray(new String[affectedIndices.size()]));
        srb.setQuery((QueryBuilder)qs);
        srb.addAggregation((AbstractAggregationBuilder)builder);
        SearchRequest request = srb.request();
        SearchResponse r = (SearchResponse)this.c.search(request).actionGet();
        this.esRequestTimer.update(r.getTookInMillis(), TimeUnit.MILLISECONDS);
        Filter f = (Filter)r.getAggregations().get(AGG_FILTER);
        return new DateHistogramResult((DateHistogram)f.getAggregations().get(AGG_HISTOGRAM), query, request.source(), interval, r.getTook());
    }

    public HistogramResult fieldHistogram(String query, String field, DateHistogramInterval interval, String filter, TimeRange range) throws FieldTypeException {
        SearchResponse r;
        FilterAggregationBuilder builder = ((FilterAggregationBuilder)AggregationBuilders.filter((String)AGG_FILTER).subAggregation((AbstractAggregationBuilder)((DateHistogramBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)AGG_HISTOGRAM).field("timestamp")).subAggregation((AbstractAggregationBuilder)AggregationBuilders.stats((String)AGG_STATS).field(field))).interval(interval.toESInterval()))).filter((FilterBuilder)this.standardFilters(range, filter));
        QueryStringQueryBuilder qs = QueryBuilders.queryStringQuery((String)query);
        qs.allowLeadingWildcard(this.configuration.isAllowLeadingWildcardSearches());
        SearchRequestBuilder srb = this.c.prepareSearch(new String[0]);
        Set<String> affectedIndices = IndexHelper.determineAffectedIndices(this.indexRangeService, this.deflector, range);
        srb.setIndices(affectedIndices.toArray(new String[affectedIndices.size()]));
        srb.setQuery((QueryBuilder)qs);
        srb.addAggregation((AbstractAggregationBuilder)builder);
        SearchRequest request = srb.request();
        try {
            r = (SearchResponse)this.c.search(request).actionGet();
        }
        catch (SearchPhaseExecutionException e) {
            throw new FieldTypeException(e);
        }
        this.esRequestTimer.update(r.getTookInMillis(), TimeUnit.MILLISECONDS);
        Filter f = (Filter)r.getAggregations().get(AGG_FILTER);
        return new FieldHistogramResult((DateHistogram)f.getAggregations().get(AGG_HISTOGRAM), query, request.source(), interval, r.getTook());
    }

    public SearchHit firstOfIndex(String index) {
        return this.oneOfIndex(index, (QueryBuilder)QueryBuilders.matchAllQuery(), SortOrder.ASC);
    }

    private SearchRequestBuilder searchRequest(SearchesConfig config, Set<String> indices) {
        SearchRequestBuilder request = config.filter() == null ? this.standardSearchRequest(config.query(), indices, config.limit(), config.offset(), config.range(), config.sorting()) : this.filteredSearchRequest(config.query(), config.filter(), indices, config.limit(), config.offset(), config.range(), config.sorting());
        if (config.fields() != null) {
            request.addFields(config.fields().toArray(new String[config.fields().size()]));
        }
        return request;
    }

    private SearchRequestBuilder standardSearchRequest(String query, Set<String> indices) {
        return this.standardSearchRequest(query, indices, 0, 0, null, null);
    }

    private SearchRequestBuilder standardSearchRequest(String query, Set<String> indices, TimeRange range) {
        return this.standardSearchRequest(query, indices, 0, 0, range, null);
    }

    private SearchRequestBuilder standardSearchRequest(String query, Set<String> indices, int limit, int offset, TimeRange range, Sorting sort) {
        return this.standardSearchRequest(query, indices, limit, offset, range, sort, true);
    }

    private SearchRequestBuilder standardSearchRequest(String query, Set<String> indices, int limit, int offset, TimeRange range, Sorting sort, boolean highlight) {
        if (query == null || query.trim().isEmpty()) {
            query = "*";
        }
        SearchRequestBuilder srb = this.c.prepareSearch(new String[0]);
        srb.setIndices(indices.toArray(new String[indices.size()]));
        if (query.trim().equals("*")) {
            srb.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        } else {
            QueryStringQueryBuilder qs = QueryBuilders.queryStringQuery((String)query);
            qs.allowLeadingWildcard(this.configuration.isAllowLeadingWildcardSearches());
            srb.setQuery((QueryBuilder)qs);
        }
        srb.setFrom(offset);
        if (limit > 0) {
            srb.setSize(limit);
        }
        if (range != null) {
            srb.setPostFilter(IndexHelper.getTimestampRangeFilter(range));
        }
        if (sort != null) {
            srb.addSort(sort.getField(), sort.asElastic());
        }
        if (highlight && this.configuration.isAllowHighlighting()) {
            srb.setHighlighterRequireFieldMatch(false);
            srb.addHighlightedField("*", 0, 0);
        }
        return srb;
    }

    private SearchRequestBuilder filteredSearchRequest(String query, String filter, Set<String> indices) {
        return this.filteredSearchRequest(query, filter, indices, 0, 0, null, null);
    }

    private SearchRequestBuilder filteredSearchRequest(String query, String filter, Set<String> indices, TimeRange range) {
        return this.filteredSearchRequest(query, filter, indices, 0, 0, range, null);
    }

    private SearchRequestBuilder filteredSearchRequest(String query, String filter, Set<String> indices, int limit, int offset, TimeRange range, Sorting sort) {
        SearchRequestBuilder srb = this.standardSearchRequest(query, indices, limit, offset, range, sort);
        if (range != null && filter != null) {
            srb.setPostFilter((FilterBuilder)this.standardFilters(range, filter));
        }
        return srb;
    }

    private SearchHit oneOfIndex(String index, QueryBuilder q, SortOrder sort) {
        SearchRequestBuilder srb = this.c.prepareSearch(new String[0]);
        srb.setIndices(new String[]{index});
        srb.setQuery(q);
        srb.setSize(1);
        srb.addSort("timestamp", sort);
        SearchResponse r = (SearchResponse)this.c.search(srb.request()).actionGet();
        this.esRequestTimer.update(r.getTookInMillis(), TimeUnit.MILLISECONDS);
        if (r.getHits() != null && r.getHits().totalHits() > 0L) {
            return r.getHits().getAt(0);
        }
        return null;
    }

    private BoolFilterBuilder standardFilters(TimeRange range, String filter) {
        BoolFilterBuilder bfb = FilterBuilders.boolFilter();
        boolean set = false;
        if (range != null) {
            bfb.must(IndexHelper.getTimestampRangeFilter(range));
            set = true;
            this.esTimeRangeHistogram.update(TimeRanges.toSeconds(range));
        }
        if (filter != null && !filter.isEmpty() && !filter.equals("*")) {
            bfb.must((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.queryStringQuery((String)filter)));
            set = true;
        }
        if (!set) {
            throw new RuntimeException("Either range or filter must be set.");
        }
        return bfb;
    }

    public static class FieldTypeException
    extends Exception {
        public FieldTypeException(Throwable e) {
            super(e);
        }
    }

    public static enum DateHistogramInterval {
        YEAR(Period.years((int)1)),
        QUARTER(Period.months((int)3)),
        MONTH(Period.months((int)1)),
        WEEK(Period.weeks((int)1)),
        DAY(Period.days((int)1)),
        HOUR(Period.hours((int)1)),
        MINUTE(Period.minutes((int)1));

        private final Period period;

        private DateHistogramInterval(Period period) {
            this.period = period;
        }

        public Period getPeriod() {
            return this.period;
        }

        public DateHistogram.Interval toESInterval() {
            switch (this.name()) {
                case "MINUTE": {
                    return DateHistogram.Interval.MINUTE;
                }
                case "HOUR": {
                    return DateHistogram.Interval.HOUR;
                }
                case "DAY": {
                    return DateHistogram.Interval.DAY;
                }
                case "WEEK": {
                    return DateHistogram.Interval.WEEK;
                }
                case "MONTH": {
                    return DateHistogram.Interval.MONTH;
                }
                case "QUARTER": {
                    return DateHistogram.Interval.QUARTER;
                }
            }
            return DateHistogram.Interval.YEAR;
        }
    }

    public static enum TermsStatsOrder {
        TERM,
        REVERSE_TERM,
        COUNT,
        REVERSE_COUNT,
        TOTAL,
        REVERSE_TOTAL,
        MIN,
        REVERSE_MIN,
        MAX,
        REVERSE_MAX,
        MEAN,
        REVERSE_MEAN;

    }
}

