/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches.timeranges;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.graylog2.utilities.date.NaturalDateParser;
import org.joda.time.DateTime;

public class KeywordRange
implements TimeRange {
    private static final NaturalDateParser DATE_PARSER = new NaturalDateParser();
    private final String keyword;
    private final boolean dynamic;
    private DateTime from;
    private DateTime to;

    public KeywordRange(String keyword, boolean dynamic) throws InvalidRangeParametersException {
        if (Strings.isNullOrEmpty((String)keyword)) {
            throw new InvalidRangeParametersException();
        }
        try {
            NaturalDateParser.Result result = this.parseKeyword(keyword);
            this.from = result.getFrom();
            this.to = result.getTo();
        }
        catch (NaturalDateParser.DateNotParsableException e) {
            throw new InvalidRangeParametersException("Could not parse from natural date: " + keyword);
        }
        this.keyword = keyword;
        this.dynamic = dynamic;
    }

    public KeywordRange(String keyword) throws InvalidRangeParametersException {
        this(keyword, false);
    }

    private NaturalDateParser.Result parseKeyword(String keyword) throws NaturalDateParser.DateNotParsableException {
        return DATE_PARSER.parse(keyword);
    }

    @Override
    public TimeRange.Type getType() {
        return TimeRange.Type.KEYWORD;
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        return ImmutableMap.builder().put((Object)"type", (Object)this.getType().toString().toLowerCase()).put((Object)"keyword", (Object)this.getKeyword()).build();
    }

    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public DateTime getFrom() {
        try {
            return this.dynamic ? this.parseKeyword(this.keyword).getFrom() : this.from;
        }
        catch (NaturalDateParser.DateNotParsableException e) {
            return this.from;
        }
    }

    @Override
    public DateTime getTo() {
        try {
            return this.dynamic ? this.parseKeyword(this.keyword).getTo() : this.to;
        }
        catch (NaturalDateParser.DateNotParsableException e) {
            return this.to;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("keyword", (Object)this.getKeyword()).add("from", (Object)this.getFrom()).add("to", (Object)this.getTo()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeywordRange that = (KeywordRange)o;
        return this.dynamic == that.dynamic && this.keyword.equals(that.keyword);
    }

    public int hashCode() {
        return Objects.hash(this.keyword, this.dynamic);
    }
}

