/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.database.validators.DateValidator;
import org.graylog2.database.validators.FilledStringValidator;
import org.graylog2.database.validators.MapValidator;
import org.graylog2.database.validators.OptionalStringValidator;
import org.graylog2.inputs.Input;
import org.graylog2.plugin.database.validators.Validator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CollectionName(value="inputs")
public class InputImpl
extends PersistedImpl
implements Input {
    private static final Logger LOG = LoggerFactory.getLogger(InputImpl.class);
    public static final String FIELD_STATIC_FIELD_KEY = "key";
    public static final String FIELD_STATIC_FIELD_VALUE = "value";
    public static final String EMBEDDED_EXTRACTORS = "extractors";
    public static final String EMBEDDED_STATIC_FIELDS = "static_fields";

    public InputImpl(Map<String, Object> fields) {
        super(fields);
    }

    public InputImpl(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
    }

    public Map<String, Validator> getValidations() {
        ImmutableMap.Builder validations = ImmutableMap.builder();
        validations.put((Object)"title", (Object)new FilledStringValidator());
        validations.put((Object)"type", (Object)new FilledStringValidator());
        validations.put((Object)"configuration", (Object)new MapValidator());
        validations.put((Object)"creator_user_id", (Object)new FilledStringValidator());
        validations.put((Object)"created_at", (Object)new DateValidator());
        validations.put((Object)"content_pack", (Object)new OptionalStringValidator());
        return validations.build();
    }

    public Map<String, Validator> getEmbeddedValidations(String key) {
        if (key.equals(EMBEDDED_EXTRACTORS)) {
            ImmutableMap.Builder validations = ImmutableMap.builder();
            validations.put((Object)"id", (Object)new FilledStringValidator());
            validations.put((Object)"title", (Object)new FilledStringValidator());
            validations.put((Object)"type", (Object)new FilledStringValidator());
            validations.put((Object)"cursor_strategy", (Object)new FilledStringValidator());
            validations.put((Object)"target_field", (Object)new FilledStringValidator());
            validations.put((Object)"source_field", (Object)new FilledStringValidator());
            validations.put((Object)"creator_user_id", (Object)new FilledStringValidator());
            validations.put((Object)"extractor_config", (Object)new MapValidator());
        }
        if (key.equals(EMBEDDED_STATIC_FIELDS)) {
            return ImmutableMap.of((Object)FIELD_STATIC_FIELD_KEY, (Object)new FilledStringValidator(), (Object)FIELD_STATIC_FIELD_VALUE, (Object)new FilledStringValidator());
        }
        return Collections.emptyMap();
    }

    @Override
    public String getTitle() {
        return (String)this.fields.get("title");
    }

    @Override
    public DateTime getCreatedAt() {
        return new DateTime(this.fields.get("created_at"), DateTimeZone.UTC);
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return (Map)this.fields.get("configuration");
    }

    @Override
    public Map<String, String> getStaticFields() {
        if (this.fields.get(EMBEDDED_STATIC_FIELDS) == null) {
            return Collections.emptyMap();
        }
        BasicDBList list = (BasicDBList)this.fields.get(EMBEDDED_STATIC_FIELDS);
        HashMap staticFields = Maps.newHashMapWithExpectedSize((int)list.size());
        for (Object element : list) {
            try {
                DBObject field = (DBObject)element;
                staticFields.put((String)field.get(FIELD_STATIC_FIELD_KEY), (String)field.get(FIELD_STATIC_FIELD_VALUE));
            }
            catch (Exception e) {
                LOG.error("Cannot build static field from persisted data. Skipping.", (Throwable)e);
            }
        }
        return staticFields;
    }

    @Override
    public String getType() {
        return (String)this.fields.get("type");
    }

    @Override
    public String getCreatorUserId() {
        return (String)this.fields.get("creator_user_id");
    }

    @Override
    public Boolean isGlobal() {
        Object global = this.fields.get("global");
        if (global instanceof Boolean) {
            return (Boolean)global;
        }
        return false;
    }

    @Override
    public String getContentPack() {
        return (String)this.fields.get("content_pack");
    }

    @Override
    public String getNodeId() {
        return Strings.emptyToNull((String)((String)this.fields.get("node_id")));
    }
}

