/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.notifications;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.cluster.Node;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationImpl;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationServiceImpl
extends PersistedServiceImpl
implements NotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationServiceImpl.class);

    @Inject
    public NotificationServiceImpl(MongoConnection mongoConnection) {
        super(mongoConnection);
    }

    @Override
    public Notification build() {
        return new NotificationImpl();
    }

    @Override
    public Notification buildNow() {
        Notification notification = this.build();
        notification.addTimestamp(Tools.iso8601());
        return notification;
    }

    @Override
    public boolean fixed(Notification.Type type) {
        return this.fixed(type, null);
    }

    @Override
    public boolean fixed(Notification.Type type, Node node) {
        BasicDBObject qry = new BasicDBObject();
        qry.put("type", (Object)type.toString().toLowerCase());
        if (node != null) {
            qry.put("node_id", (Object)node.getNodeId());
        }
        return this.destroyAll(NotificationImpl.class, (DBObject)qry) > 0;
    }

    @Override
    public boolean isFirst(Notification.Type type) {
        return this.findOne(NotificationImpl.class, (DBObject)new BasicDBObject("type", (Object)type.toString().toLowerCase())) == null;
    }

    @Override
    public List<Notification> all() {
        ArrayList notifications = Lists.newArrayList();
        for (DBObject obj : this.query(NotificationImpl.class, (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("timestamp", (Object)-1))) {
            try {
                notifications.add(new NotificationImpl(new ObjectId(obj.get("_id").toString()), obj.toMap()));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("There is a notification type we can't handle: [" + obj.get("type") + "]");
            }
        }
        return notifications;
    }

    @Override
    public boolean publishIfFirst(Notification notification) {
        if (notification.getNodeId() == null) {
            this.addThisNode(notification);
        }
        if (notification.getTimestamp() == null) {
            notification.addTimestamp(Tools.iso8601());
        }
        if (!this.isFirst(notification.getType())) {
            return false;
        }
        try {
            this.save(notification);
        }
        catch (ValidationException e) {
            LOG.error("Validating user warning failed.", (Throwable)e);
            return false;
        }
        return true;
    }

    private Notification addThisNode(Notification notification) {
        return notification;
    }

    @Override
    public boolean fixed(Notification notification) {
        return this.fixed(notification.getType(), null);
    }

    @Override
    public int destroyAllByType(Notification.Type type) {
        return this.destroyAll(NotificationImpl.class, (DBObject)new BasicDBObject("type", (Object)type.toString().toLowerCase()));
    }
}

