/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.collector;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.graylog2.collectors.Collector;
import org.graylog2.collectors.CollectorService;
import org.graylog2.rest.models.collector.requests.CollectorRegistrationRequest;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="System/Collectors/Registration", description="Registration resource for Graylog Collector nodes.")
@Path(value="/system/collectors/{collectorId}")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CollectorRegistrationResource
extends RestResource {
    private final CollectorService collectorService;

    @Inject
    public CollectorRegistrationResource(CollectorService collectorService) {
        this.collectorService = collectorService;
    }

    @PUT
    @Timed
    @ApiOperation(value="Create/update an collector registration", notes="This is a stateless method which upserts a collector registration")
    @ApiResponses(value={@ApiResponse(code=400, message="The supplied request is not valid.")})
    public Response register(@ApiParam(name="collectorId", value="The collector id this collector is registering as.", required=true) @PathParam(value="collectorId") String collectorId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CollectorRegistrationRequest request, @HeaderParam(value="X-Graylog-Collector-Version") String collectorVersion) {
        Collector collector = this.collectorService.fromRequest(collectorId, request, collectorVersion);
        this.collectorService.save(collector);
        return Response.accepted().build();
    }
}

