/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.collector;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Function;
import com.google.common.primitives.Ints;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.Configuration;
import org.graylog2.collectors.Collector;
import org.graylog2.collectors.CollectorService;
import org.graylog2.collectors.Collectors;
import org.graylog2.database.NotFoundException;
import org.graylog2.rest.models.collector.responses.CollectorList;
import org.graylog2.rest.models.collector.responses.CollectorSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Api(value="System/Collectors", description="Management of Graylog Collectors.")
@Path(value="/system/collectors")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
@RequiresPermissions(value={"collectors:read"})
public class CollectorResource
extends RestResource {
    private final CollectorService collectorService;
    private final LostCollectorFunction lostCollectorFunction;

    @Inject
    public CollectorResource(CollectorService collectorService, Configuration config) {
        this.collectorService = collectorService;
        this.lostCollectorFunction = new LostCollectorFunction(config.getCollectorInactiveThreshold().toSeconds());
    }

    @GET
    @Timed
    @ApiOperation(value="Lists all existing collector registrations")
    public CollectorList list() {
        List<Collector> collectors = this.collectorService.all();
        List<CollectorSummary> collectorSummaries = Collectors.toSummaryList(collectors, this.lostCollectorFunction);
        return CollectorList.create(collectorSummaries);
    }

    @GET
    @Timed
    @Path(value="/{collectorId}")
    @ApiOperation(value="Returns at most one collector summary for the specified collector id")
    @ApiResponses(value={@ApiResponse(code=404, message="No collector with the specified id exists")})
    public CollectorSummary get(@ApiParam(name="collectorId", required=true) @PathParam(value="collectorId") String collectorId) throws NotFoundException {
        Collector collector = this.collectorService.findById(collectorId);
        if (collector != null) {
            return collector.toSummary(this.lostCollectorFunction);
        }
        throw new NotFoundException("Collector <" + collectorId + "> not found!");
    }

    public class LostCollectorFunction
    implements Function<Collector, Boolean> {
        private final long timeOutInSeconds;

        @Inject
        public LostCollectorFunction(long timeOutInSeconds) {
            this.timeOutInSeconds = timeOutInSeconds;
        }

        public Boolean apply(Collector collector) {
            DateTime threshold = DateTime.now().minusSeconds(Ints.checkedCast((long)this.timeOutInSeconds));
            return collector.getLastSeen().isAfter((ReadableInstant)threshold);
        }
    }
}

