/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.jobs;

import com.google.common.base.Preconditions;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;

public abstract class SystemJob {
    protected String id;
    protected DateTime startedAt;

    public abstract void execute();

    public abstract void requestCancel();

    public abstract int getProgress();

    public abstract int maxConcurrency();

    public abstract boolean providesProgress();

    public abstract boolean isCancelable();

    public abstract String getDescription();

    public abstract String getClassName();

    public String getInfo() {
        return "No further information available.";
    }

    public String getId() {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"Cannot return ID if the job has not been started yet.");
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void markStarted() {
        this.startedAt = Tools.iso8601();
    }

    public DateTime getStartedAt() {
        return this.startedAt;
    }

    public static enum Type {
        FIX_DEFLECTOR_DELETE_INDEX,
        FIX_DEFLECTOR_MOVE_INDEX;

    }
}

