/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.database.EmbeddedPersistable;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;

public abstract class AbstractAlertCondition
implements EmbeddedPersistable,
AlertCondition {
    protected final String id;
    protected final Stream stream;
    protected final String type;
    protected final DateTime createdAt;
    protected final String creatorUserId;
    protected final int grace;
    protected final int backlog;
    protected final boolean repeatNotifications;
    protected final String title;
    private Map<String, Object> parameters;

    protected AbstractAlertCondition(Stream stream, String id, String type, DateTime createdAt, String creatorUserId, Map<String, Object> parameters, String title) {
        this.title = title;
        this.id = id == null ? UUID.randomUUID().toString() : id;
        this.stream = stream;
        this.type = type;
        this.createdAt = createdAt;
        this.creatorUserId = creatorUserId;
        this.parameters = ImmutableMap.copyOf(parameters);
        this.grace = Tools.getNumber(this.parameters.get("grace"), 0).intValue();
        this.backlog = Tools.getNumber(this.parameters.get("backlog"), 0).intValue();
        this.repeatNotifications = (Boolean)this.parameters.getOrDefault("repeat_notifications", false);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    @Override
    @JsonIgnore
    public Stream getStream() {
        return this.stream;
    }

    protected void setParameters(Map<String, Object> parameters) {
        this.parameters = ImmutableMap.copyOf(parameters);
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public Integer getBacklog() {
        return this.backlog;
    }

    public String toString() {
        return this.id + ":" + this.type + "={" + this.getDescription() + "}" + ", stream:={" + this.stream + "}";
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getPersistedFields() {
        return ImmutableMap.builder().put((Object)"id", (Object)this.id).put((Object)"type", (Object)this.type).put((Object)"creator_user_id", (Object)this.creatorUserId).put((Object)"created_at", (Object)Tools.getISO8601String(this.createdAt)).put((Object)"parameters", this.parameters).put((Object)"title", (Object)this.title).build();
    }

    @Override
    public int getGrace() {
        return this.grace;
    }

    @Override
    public boolean shouldRepeatNotifications() {
        return this.repeatNotifications;
    }

    public static List<ConfigurationField> getDefaultConfigurationFields() {
        return Lists.newArrayList((Object[])new ConfigurationField[]{new NumberField("grace", "Grace Period", 0, "Number of minutes to wait after an alert is resolved, to trigger another alert", ConfigurationField.Optional.NOT_OPTIONAL), new NumberField("backlog", "Message Backlog", 0, "The number of messages to be included in alert notifications", ConfigurationField.Optional.NOT_OPTIONAL), new BooleanField("repeat_notifications", "Repeat notifications", false, "Check this box to send notifications every time the alert condition is evaluated and satisfied regardless of its state.")});
    }

    public static class NegativeCheckResult
    extends CheckResult {
        public NegativeCheckResult() {
            super(false, null, null, null, null);
        }
    }

    public static class CheckResult
    implements AlertCondition.CheckResult {
        private final boolean isTriggered;
        private final String resultDescription;
        private final AlertCondition triggeredCondition;
        private final DateTime triggeredAt;
        private final ArrayList<MessageSummary> summaries = Lists.newArrayList();

        public CheckResult(boolean isTriggered, AlertCondition triggeredCondition, String resultDescription, DateTime triggeredAt, List<MessageSummary> summaries) {
            this.isTriggered = isTriggered;
            this.resultDescription = resultDescription;
            this.triggeredCondition = triggeredCondition;
            this.triggeredAt = triggeredAt;
            if (summaries != null) {
                this.summaries.addAll(summaries);
            }
        }

        @Override
        public boolean isTriggered() {
            return this.isTriggered;
        }

        @Override
        public String getResultDescription() {
            return this.resultDescription;
        }

        @Override
        public AlertCondition getTriggeredCondition() {
            return this.triggeredCondition;
        }

        @Override
        public DateTime getTriggeredAt() {
            return this.triggeredAt;
        }

        @Override
        public List<MessageSummary> getMatchingMessages() {
            return this.summaries;
        }
    }

    public static enum Type {
        MESSAGE_COUNT,
        FIELD_VALUE,
        FIELD_CONTENT_VALUE,
        DUMMY;


        @JsonValue
        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

