/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards;

import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.dashboards.Dashboard;
import org.graylog2.dashboards.DashboardImpl;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.DashboardWidgetCreator;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.rest.models.dashboards.requests.WidgetPositionsRequest;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardServiceImpl
extends PersistedServiceImpl
implements DashboardService {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardServiceImpl.class);
    private final DashboardWidgetCreator dashboardWidgetCreator;

    @Inject
    public DashboardServiceImpl(MongoConnection mongoConnection, DashboardWidgetCreator dashboardWidgetCreator) {
        super(mongoConnection);
        this.dashboardWidgetCreator = dashboardWidgetCreator;
    }

    @Override
    public Dashboard create(String title, String description, String creatorUserId, DateTime createdAt) {
        HashMap dashboardData = Maps.newHashMap();
        dashboardData.put("title", title);
        dashboardData.put("description", description);
        dashboardData.put("creator_user_id", creatorUserId);
        dashboardData.put("created_at", createdAt);
        return new DashboardImpl(dashboardData);
    }

    private Dashboard create(ObjectId id, Map<String, Object> fields) {
        DashboardImpl dashboard = new DashboardImpl(id, fields);
        if (fields.containsKey("widgets") && fields.get("widgets") instanceof List) {
            for (BasicDBObject widgetFields : (List)fields.get("widgets")) {
                try {
                    DashboardWidget widget = this.dashboardWidgetCreator.fromPersisted(widgetFields);
                    dashboard.addPersistedWidget(widget);
                }
                catch (DashboardWidget.NoSuchWidgetTypeException e) {
                    LOG.error("No such widget type: [" + widgetFields.get("type") + "] - Dashboard: [" + dashboard.getId() + "]", (Throwable)e);
                }
                catch (InvalidRangeParametersException e) {
                    LOG.error("Invalid range parameters of widget in dashboard: [" + dashboard.getId() + "]", (Throwable)e);
                }
                catch (InvalidWidgetConfigurationException e) {
                    LOG.error("Invalid configuration of widget in dashboard: [" + dashboard.getId() + "]", (Throwable)e);
                }
            }
        }
        return dashboard;
    }

    @Override
    public Dashboard load(String id) throws NotFoundException {
        BasicDBObject o = (BasicDBObject)this.get(DashboardImpl.class, id);
        if (o == null) {
            throw new NotFoundException("Couldn't find dashboard with ID " + id);
        }
        Dashboard dashboard = this.create((ObjectId)o.get("_id"), o.toMap());
        return dashboard;
    }

    @Override
    public List<Dashboard> all() {
        List<DBObject> results = this.query(DashboardImpl.class, (DBObject)new BasicDBObject());
        return results.stream().map(o -> new DashboardImpl((ObjectId)o.get("_id"), o.toMap())).collect(Collectors.toList());
    }

    @Override
    public void updateWidgetPositions(Dashboard dashboard, WidgetPositionsRequest positions) throws ValidationException {
        HashMap map = Maps.newHashMap();
        for (WidgetPositionsRequest.WidgetPosition position : positions.positions()) {
            HashMap x = Maps.newHashMap();
            x.put("col", position.col());
            x.put("row", position.row());
            x.put("height", position.height());
            x.put("width", position.width());
            map.put(position.id(), x);
        }
        dashboard.getFields().put("positions", map);
        this.save(dashboard);
    }

    @Override
    public void addWidget(Dashboard dashboard, DashboardWidget widget) throws ValidationException {
        this.embed(dashboard, "widgets", widget);
        dashboard.addWidget(widget);
    }

    @Override
    public void removeWidget(Dashboard dashboard, DashboardWidget widget) {
        this.removeEmbedded(dashboard, "widgets", widget.getId());
        dashboard.removeWidget(widget);
    }

    @Override
    @Deprecated
    public void updateWidgetDescription(Dashboard dashboard, DashboardWidget widget, String newDescription) throws ValidationException {
        widget.setDescription(newDescription);
        this.removeWidget(dashboard, widget);
        this.addWidget(dashboard, widget);
    }

    @Override
    @Deprecated
    public void updateWidgetCacheTime(Dashboard dashboard, DashboardWidget widget, int cacheTime) throws ValidationException {
        widget.setCacheTime(cacheTime);
        this.removeWidget(dashboard, widget);
        this.addWidget(dashboard, widget);
    }

    @Override
    public long count() {
        return this.totalCount(DashboardImpl.class);
    }
}

