/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.decorators;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.decorators.DecoratorProcessor;
import org.graylog2.decorators.DecoratorResolver;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.decorators.SearchResponseDecorator;
import org.graylog2.rest.models.messages.responses.DecorationStats;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.resources.search.responses.SearchDecorationStats;
import org.graylog2.rest.resources.search.responses.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoratorProcessorImpl
implements DecoratorProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DecoratorProcessorImpl.class);
    private final DecoratorResolver decoratorResolver;

    @Inject
    public DecoratorProcessorImpl(DecoratorResolver decoratorResolver) {
        this.decoratorResolver = decoratorResolver;
    }

    @Override
    public SearchResponse decorate(SearchResponse searchResponse, Optional<String> streamId) {
        try {
            List<SearchResponseDecorator> searchResponseDecorators = streamId.isPresent() ? this.decoratorResolver.searchResponseDecoratorsForStream(streamId.get()) : this.decoratorResolver.searchResponseDecoratorsForGlobal();
            Optional metaDecorator = searchResponseDecorators.stream().reduce((f, g) -> v -> (SearchResponse)g.apply((SearchResponse)f.apply(v)));
            if (metaDecorator.isPresent()) {
                Map originalMessages = searchResponse.messages().stream().collect(Collectors.toMap(this::getMessageKey, Function.identity()));
                SearchResponse newSearchResponse = (SearchResponse)((SearchResponseDecorator)metaDecorator.get()).apply(searchResponse);
                Set<String> newFields = this.extractFields(newSearchResponse.messages());
                List<ResultMessageSummary> decoratedMessages = newSearchResponse.messages().stream().map(resultMessage -> {
                    ResultMessageSummary originalMessage = (ResultMessageSummary)originalMessages.get(this.getMessageKey((ResultMessageSummary)resultMessage));
                    if (originalMessage != null) {
                        return resultMessage.toBuilder().decorationStats(DecorationStats.create(originalMessage.message(), resultMessage.message())).build();
                    }
                    return resultMessage;
                }).collect(Collectors.toList());
                return newSearchResponse.toBuilder().messages(decoratedMessages).fields(newFields).decorationStats(this.getSearchDecoratorStats(decoratedMessages)).build();
            }
        }
        catch (Exception e) {
            LOG.error("Error decorating search response", (Throwable)e);
        }
        return searchResponse;
    }

    private String getMessageKey(ResultMessageSummary messageSummary) {
        return messageSummary.index() + "-" + messageSummary.message().get("_id").toString();
    }

    private Set<String> extractFields(List<ResultMessageSummary> messages) {
        return messages.stream().flatMap(message -> message.message().keySet().stream()).filter(field -> !Message.RESERVED_FIELDS.contains(field)).collect(Collectors.toSet());
    }

    private SearchDecorationStats getSearchDecoratorStats(List<ResultMessageSummary> decoratedMessages) {
        HashSet<String> addedFields = new HashSet<String>();
        HashSet<String> changedFields = new HashSet<String>();
        HashSet<String> removedFields = new HashSet<String>();
        decoratedMessages.forEach(message -> {
            DecorationStats decorationStats = message.decorationStats();
            if (decorationStats != null) {
                addedFields.addAll(decorationStats.addedFields().keySet());
                changedFields.addAll(decorationStats.changedFields().keySet());
                removedFields.addAll(decorationStats.removedFields().keySet());
            }
        });
        return SearchDecorationStats.create(addedFields, changedFields, removedFields);
    }
}

