/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.filters.blacklist;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.graylog2.filters.blacklist.FilterDescription;
import org.jboss.netty.handler.ipfilter.IpSubnet;

public final class BlacklistIpMatcherCondition
extends FilterDescription {
    private IpSubnet ipSubnet;

    @JsonProperty
    public void setPattern(String pattern) {
        this.pattern = pattern;
        try {
            this.ipSubnet = new IpSubnet(pattern);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IP subnet pattern", e);
        }
    }

    public boolean matchesInetAddress(InetAddress otherSource) {
        try {
            return this.ipSubnet.contains(otherSource);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlacklistIpMatcherCondition)) {
            return false;
        }
        BlacklistIpMatcherCondition that = (BlacklistIpMatcherCondition)o;
        return Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }
}

