/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.ComparisonChain;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.NoTargetIndexException;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indices.TooManyAliasesException;

public class TestIndexSet
implements IndexSet {
    private static final String SEPARATOR = "_";
    private static final String DEFLECTOR_SUFFIX = "deflector";
    private final IndexSetConfig config;

    public TestIndexSet(IndexSetConfig config) {
        this.config = config;
    }

    @Override
    public String[] getManagedIndices() {
        return new String[0];
    }

    @Override
    public String getWriteIndexAlias() {
        return this.config.indexPrefix() + SEPARATOR + DEFLECTOR_SUFFIX;
    }

    @Override
    public String getIndexWildcard() {
        return this.config.indexPrefix() + SEPARATOR + "*";
    }

    @Override
    public String getNewestIndex() throws NoTargetIndexException {
        return null;
    }

    @Override
    public String getActiveWriteIndex() throws TooManyAliasesException {
        return null;
    }

    @Override
    public Map<String, Set<String>> getAllIndexAliases() {
        return null;
    }

    @Override
    public String getIndexPrefix() {
        return null;
    }

    @Override
    public boolean isUp() {
        return false;
    }

    @Override
    public boolean isWriteIndexAlias(String index) {
        return false;
    }

    @Override
    public boolean isManagedIndex(String index) {
        return false;
    }

    @Override
    public void setUp() {
    }

    @Override
    public void cycle() {
    }

    @Override
    public void cleanupAliases(Set<String> indices) {
    }

    @Override
    public void pointTo(String shouldBeTarget, String currentTarget) {
    }

    @Override
    public Optional<Integer> extractIndexNumber(String index) {
        return null;
    }

    @Override
    public IndexSetConfig getConfig() {
        return this.config;
    }

    @Override
    public int compareTo(IndexSet o) {
        return ComparisonChain.start().compare((Comparable)this.getConfig(), (Comparable)o.getConfig()).result();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestIndexSet that = (TestIndexSet)o;
        return Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return this.config.hashCode();
    }

    public String toString() {
        return "MongoIndexSet{config=" + this.config + '}';
    }
}

