/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.counts;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;

@Singleton
public class Counts {
    private final Client c;
    private final IndexSetRegistry indexSetRegistry;

    @Inject
    public Counts(Client client, IndexSetRegistry indexSetRegistry) {
        this.c = client;
        this.indexSetRegistry = indexSetRegistry;
    }

    public long total() {
        return this.totalCount(this.indexSetRegistry.getManagedIndices());
    }

    public long total(IndexSet indexSet) {
        return this.totalCount(indexSet.getManagedIndices());
    }

    private long totalCount(String[] indexNames) {
        if (indexNames.length == 0) {
            return 0L;
        }
        try {
            return ((SearchResponse)this.c.prepareSearch(indexNames).setSize(0).get()).getHits().getTotalHits();
        }
        catch (ElasticsearchException e) {
            return -1L;
        }
    }
}

