/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.stats.Stats;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadablePeriod;

public class FieldHistogramResult
extends HistogramResult {
    private static final Map<String, Number> EMPTY_RESULT = ImmutableMap.builder().put((Object)"count", (Object)0).put((Object)"min", (Object)0).put((Object)"max", (Object)0).put((Object)"total", (Object)0).put((Object)"total_count", (Object)0).put((Object)"mean", (Object)0).build();
    private final Histogram result;
    private final Searches.DateHistogramInterval interval;

    public FieldHistogramResult(Histogram result, String originalQuery, BytesReference builtQuery, Searches.DateHistogramInterval interval, TimeValue took) {
        super(originalQuery, builtQuery, took);
        this.result = result;
        this.interval = interval;
    }

    @Override
    public Searches.DateHistogramInterval getInterval() {
        return this.interval;
    }

    @Override
    public Map<Long, Map<String, Number>> getResults() {
        if (this.result.getBuckets().isEmpty()) {
            return Collections.emptyMap();
        }
        TreeMap results = Maps.newTreeMap();
        for (Histogram.Bucket b : this.result.getBuckets()) {
            ImmutableMap.Builder resultMap = ImmutableMap.builder();
            resultMap.put((Object)"total_count", (Object)b.getDocCount());
            Stats stats = (Stats)b.getAggregations().get("gl2_stats");
            resultMap.put((Object)"count", (Object)stats.getCount());
            resultMap.put((Object)"min", (Object)stats.getMin());
            resultMap.put((Object)"max", (Object)stats.getMax());
            resultMap.put((Object)"total", (Object)stats.getSum());
            resultMap.put((Object)"mean", (Object)stats.getAvg());
            Cardinality cardinality = (Cardinality)b.getAggregations().get("gl2_field_cardinality");
            resultMap.put((Object)"cardinality", (Object)(cardinality == null ? 0L : cardinality.getValue()));
            DateTime keyAsDate = (DateTime)b.getKey();
            long timestamp = keyAsDate.getMillis() / 1000L;
            results.put(timestamp, resultMap.build());
        }
        long minTimestamp = (Long)Collections.min(results.keySet());
        long maxTimestamp = (Long)Collections.max(results.keySet());
        MutableDateTime currentTime = new MutableDateTime(minTimestamp, DateTimeZone.UTC);
        while (currentTime.getMillis() < maxTimestamp) {
            Map entry = (Map)results.get(currentTime.getMillis());
            currentTime.add((ReadablePeriod)this.interval.getPeriod());
            if (entry != null) continue;
            results.put(currentTime.getMillis(), EMPTY_RESULT);
        }
        return results;
    }
}

