/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import java.util.Map;
import org.graylog2.ConfigurationException;
import org.graylog2.inputs.converters.CsvConverter;
import org.graylog2.inputs.converters.DateConverter;
import org.graylog2.inputs.converters.FlexibleDateConverter;
import org.graylog2.inputs.converters.HashConverter;
import org.graylog2.inputs.converters.IPAnonymizerConverter;
import org.graylog2.inputs.converters.LowercaseConverter;
import org.graylog2.inputs.converters.NumericConverter;
import org.graylog2.inputs.converters.SplitAndCountConverter;
import org.graylog2.inputs.converters.SyslogPriFacilityConverter;
import org.graylog2.inputs.converters.SyslogPriLevelConverter;
import org.graylog2.inputs.converters.TokenizerConverter;
import org.graylog2.inputs.converters.UppercaseConverter;
import org.graylog2.plugin.inputs.Converter;

public class ConverterFactory {
    public static Converter factory(Converter.Type type, Map<String, Object> config) throws NoSuchConverterException, ConfigurationException {
        switch (type) {
            case NUMERIC: {
                return new NumericConverter(config);
            }
            case DATE: {
                return new DateConverter(config);
            }
            case HASH: {
                return new HashConverter(config);
            }
            case SPLIT_AND_COUNT: {
                return new SplitAndCountConverter(config);
            }
            case SYSLOG_PRI_LEVEL: {
                return new SyslogPriLevelConverter(config);
            }
            case SYSLOG_PRI_FACILITY: {
                return new SyslogPriFacilityConverter(config);
            }
            case IP_ANONYMIZER: {
                return new IPAnonymizerConverter(config);
            }
            case TOKENIZER: {
                return new TokenizerConverter(config);
            }
            case CSV: {
                return new CsvConverter(config);
            }
            case LOWERCASE: {
                return new LowercaseConverter(config);
            }
            case UPPERCASE: {
                return new UppercaseConverter(config);
            }
            case FLEXDATE: {
                return new FlexibleDateConverter(config);
            }
        }
        throw new NoSuchConverterException();
    }

    public static class NoSuchConverterException
    extends Exception {
    }
}

