/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.extractors;

import com.codahale.metrics.MetricRegistry;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.ConfigurationException;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.inputs.extractors.CopyInputExtractor;
import org.graylog2.inputs.extractors.GrokExtractor;
import org.graylog2.inputs.extractors.JsonExtractor;
import org.graylog2.inputs.extractors.RegexExtractor;
import org.graylog2.inputs.extractors.RegexReplaceExtractor;
import org.graylog2.inputs.extractors.SplitAndIndexExtractor;
import org.graylog2.inputs.extractors.SubstringExtractor;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;

public class ExtractorFactory {
    private final MetricRegistry metricRegistry;
    private final GrokPatternService grokPatternService;

    @Inject
    public ExtractorFactory(MetricRegistry metricRegistry, GrokPatternService grokPatternService) {
        this.metricRegistry = metricRegistry;
        this.grokPatternService = grokPatternService;
    }

    public Extractor factory(String id, String title, long order, Extractor.CursorStrategy cursorStrategy, Extractor.Type type, String sourceField, String targetField, Map<String, Object> extractorConfig, String creatorUserId, List<Converter> converters, Extractor.ConditionType conditionType, String conditionValue) throws NoSuchExtractorException, Extractor.ReservedFieldException, ConfigurationException {
        switch (type) {
            case REGEX: {
                return new RegexExtractor(this.metricRegistry, id, title, order, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
            }
            case SUBSTRING: {
                return new SubstringExtractor(this.metricRegistry, id, title, order, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
            }
            case SPLIT_AND_INDEX: {
                return new SplitAndIndexExtractor(this.metricRegistry, id, title, order, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
            }
            case COPY_INPUT: {
                return new CopyInputExtractor(this.metricRegistry, id, title, order, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
            }
            case REGEX_REPLACE: {
                return new RegexReplaceExtractor(this.metricRegistry, id, title, order, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
            }
            case GROK: {
                return new GrokExtractor(this.metricRegistry, this.grokPatternService.loadAll(), id, title, order, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
            }
            case JSON: {
                return new JsonExtractor(this.metricRegistry, id, title, order, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
            }
        }
        throw new NoSuchExtractorException();
    }

    public static class NoSuchExtractorException
    extends Exception {
    }
}

