/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.github.joschi.jadconfig.util.Size;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.transports.AbstractTcpTransport;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.inputs.util.ConnectionCounter;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class HttpTransport
extends AbstractTcpTransport {
    static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    static final int DEFAULT_MAX_CHUNK_SIZE = (int)Size.kilobytes((long)64L).toBytes();
    static final int DEFAULT_IDLE_WRITER_TIMEOUT = 60;
    static final String CK_ENABLE_CORS = "enable_cors";
    static final String CK_MAX_CHUNK_SIZE = "max_chunk_size";
    static final String CK_IDLE_WRITER_TIMEOUT = "idle_writer_timeout";
    private final boolean enableCors;
    private final HashedWheelTimer timer;
    private final int maxChunkSize;
    private final int idleWriterTimeout;

    @AssistedInject
    public HttpTransport(@Assisted Configuration configuration, @Named(value="bossPool") Executor bossPool, ThroughputCounter throughputCounter, ConnectionCounter connectionCounter, HashedWheelTimer timer, LocalMetricRegistry localRegistry) {
        super(configuration, throughputCounter, localRegistry, bossPool, HttpTransport.executorService("worker", "http-transport-worker-%d", localRegistry), connectionCounter);
        this.enableCors = configuration.getBoolean(CK_ENABLE_CORS);
        this.timer = timer;
        int maxChunkSize = configuration.intIsSet(CK_MAX_CHUNK_SIZE) ? configuration.getInt(CK_MAX_CHUNK_SIZE) : DEFAULT_MAX_CHUNK_SIZE;
        this.maxChunkSize = maxChunkSize <= 0 ? DEFAULT_MAX_CHUNK_SIZE : maxChunkSize;
        this.idleWriterTimeout = configuration.intIsSet(CK_IDLE_WRITER_TIMEOUT) ? configuration.getInt(CK_IDLE_WRITER_TIMEOUT, 60) : 60;
    }

    private static Executor executorService(String executorName, String threadNameFormat, MetricRegistry metricRegistry) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadNameFormat).build();
        return new InstrumentedExecutorService(Executors.newCachedThreadPool(threadFactory), metricRegistry, MetricRegistry.name(HttpTransport.class, (String[])new String[]{executorName, "executor-service"}));
    }

    @Override
    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getBaseChannelHandlers(MessageInput input) {
        LinkedHashMap<String, Callable<? extends ChannelHandler>> baseChannelHandlers = super.getBaseChannelHandlers(input);
        if (this.idleWriterTimeout > 0) {
            baseChannelHandlers.put("read-timeout-handler", (Callable<? extends ChannelHandler>)new Callable<ChannelHandler>(){

                @Override
                public ChannelHandler call() throws Exception {
                    return new ReadTimeoutHandler((Timer)HttpTransport.this.timer, (long)HttpTransport.this.idleWriterTimeout, TimeUnit.SECONDS);
                }
            });
        }
        baseChannelHandlers.put("decoder", (Callable<? extends ChannelHandler>)new Callable<ChannelHandler>(){

            @Override
            public ChannelHandler call() throws Exception {
                return new HttpRequestDecoder(4096, 8192, HttpTransport.this.maxChunkSize);
            }
        });
        baseChannelHandlers.put("aggregator", (Callable<? extends ChannelHandler>)new Callable<ChannelHandler>(){

            @Override
            public ChannelHandler call() throws Exception {
                return new HttpChunkAggregator(HttpTransport.this.maxChunkSize);
            }
        });
        baseChannelHandlers.put("encoder", (Callable<? extends ChannelHandler>)new Callable<ChannelHandler>(){

            @Override
            public ChannelHandler call() throws Exception {
                return new HttpResponseEncoder();
            }
        });
        baseChannelHandlers.put("decompressor", (Callable<? extends ChannelHandler>)new Callable<ChannelHandler>(){

            @Override
            public ChannelHandler call() throws Exception {
                return new HttpContentDecompressor();
            }
        });
        return baseChannelHandlers;
    }

    @Override
    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getFinalChannelHandlers(MessageInput input) {
        LinkedHashMap handlers = Maps.newLinkedHashMap();
        handlers.put("http-handler", new Callable<ChannelHandler>(){

            @Override
            public ChannelHandler call() throws Exception {
                return new Handler(HttpTransport.this.enableCors);
            }
        });
        handlers.putAll(super.getFinalChannelHandlers(input));
        return handlers;
    }

    public static class Handler
    extends SimpleChannelHandler {
        private final boolean enableCors;

        public Handler(boolean enableCors) {
            this.enableCors = enableCors;
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Channel channel = e.getChannel();
            HttpRequest request = (HttpRequest)e.getMessage();
            boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
            HttpVersion httpRequestVersion = request.getProtocolVersion();
            String origin = request.headers().get("Origin");
            if (HttpMethod.OPTIONS.equals((Object)request.getMethod())) {
                this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.OK, origin);
                return;
            }
            if (!HttpMethod.POST.equals((Object)request.getMethod())) {
                this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.METHOD_NOT_ALLOWED, origin);
                return;
            }
            ChannelBuffer buffer = request.getContent();
            boolean correctPath = "/gelf".equals(request.getUri());
            if (!correctPath) {
                this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.NOT_FOUND, origin);
            } else {
                this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.ACCEPTED, origin);
                Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)buffer);
            }
        }

        private void writeResponse(Channel channel, boolean keepAlive, HttpVersion httpRequestVersion, HttpResponseStatus status, String origin) {
            DefaultHttpResponse response = new DefaultHttpResponse(httpRequestVersion, status);
            response.headers().set("Content-Length", (Object)0);
            response.headers().set("Connection", (Object)(keepAlive ? "keep-alive" : "close"));
            if (this.enableCors && origin != null && !origin.isEmpty()) {
                response.headers().set("Access-Control-Allow-Origin", (Object)origin);
                response.headers().set("Access-Control-Allow-Credentials", (Object)true);
                response.headers().set("Access-Control-Allow-Headers", (Object)"Authorization, Content-Type");
            }
            ChannelFuture channelFuture = channel.write((Object)response);
            if (!keepAlive) {
                channelFuture.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    @ConfigClass
    public static class Config
    extends AbstractTcpTransport.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = super.getRequestedConfiguration();
            r.addField(new BooleanField(HttpTransport.CK_ENABLE_CORS, "Enable CORS", true, "Input sends CORS headers to satisfy browser security policies"));
            r.addField(new NumberField(HttpTransport.CK_MAX_CHUNK_SIZE, "Max. HTTP chunk size", DEFAULT_MAX_CHUNK_SIZE, "The maximum HTTP chunk size in bytes (e. g. length of HTTP request body)", ConfigurationField.Optional.OPTIONAL));
            r.addField(new NumberField(HttpTransport.CK_IDLE_WRITER_TIMEOUT, "Idle writer timeout", 60, "The server closes the connection after the given time in seconds after the last client write request. (use 0 to disable)", ConfigurationField.Optional.OPTIONAL, NumberField.Attribute.ONLY_POSITIVE));
            return r;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<HttpTransport> {
        @Override
        public HttpTransport create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

