/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import java.util.Map;
import javax.inject.Inject;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.process.ProcessStats;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerClusterCheckerThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexerClusterCheckerThread.class);
    private static final int MINIMUM_OPEN_FILES_LIMIT = 64000;
    private final NotificationService notificationService;
    private final Cluster cluster;

    @Inject
    public IndexerClusterCheckerThread(NotificationService notificationService, Cluster cluster) {
        this.notificationService = notificationService;
        this.cluster = cluster;
    }

    @Override
    public void doRun() {
        if (!this.notificationService.isFirst(Notification.Type.ES_OPEN_FILES)) {
            return;
        }
        try {
            ClusterHealthStatus clusterHealthStatus = this.cluster.health().getStatus();
        }
        catch (Exception e) {
            LOG.info("Indexer not fully initialized yet. Skipping periodic cluster check.");
            return;
        }
        boolean allHigher = true;
        Map<String, NodeInfo> nodesInfos = this.cluster.getDataNodes();
        Map<String, NodeStats> nodesStats = this.cluster.getNodesStats(nodesInfos.keySet().toArray(new String[nodesInfos.size()]));
        for (Map.Entry<String, NodeStats> entry : nodesStats.entrySet()) {
            String nodeId = entry.getKey();
            NodeStats nodeStats = entry.getValue();
            NodeInfo nodeInfo = nodesInfos.get(nodeId);
            String nodeName = nodeInfo.getNode().getName();
            ProcessStats processStats = nodeStats.getProcess();
            if (processStats == null) {
                LOG.debug("Couldn't read process stats of Elasticsearch node {}", (Object)nodeName);
                return;
            }
            long maxFileDescriptors = processStats.getMaxFileDescriptors();
            JvmInfo jvmInfo = nodeInfo.getJvm();
            if (jvmInfo == null) {
                LOG.debug("Couldn't read JVM info of Elasticsearch node {}", (Object)nodeName);
                return;
            }
            String osName = jvmInfo.getSystemProperties().getOrDefault("os.name", "");
            if (osName.startsWith("Windows")) {
                LOG.debug("Skipping open file limit check for Indexer node <{}> on Windows", (Object)nodeName);
                continue;
            }
            if (maxFileDescriptors == -1L || maxFileDescriptors >= 64000L) continue;
            Notification notification = this.notificationService.buildNow().addType(Notification.Type.ES_OPEN_FILES).addSeverity(Notification.Severity.URGENT).addDetail("hostname", nodeInfo.getHostname()).addDetail("max_file_descriptors", maxFileDescriptors);
            if (this.notificationService.publishIfFirst(notification)) {
                LOG.warn("Indexer node <{}> open file limit is too low: [{}]. Set it to at least {}.", new Object[]{nodeName, maxFileDescriptors, 64000});
            }
            allHigher = false;
        }
        if (allHigher) {
            Notification notification = this.notificationService.build().addType(Notification.Type.ES_OPEN_FILES);
            this.notificationService.fixed(notification);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 30;
    }
}

