/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    private static final ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
    public static final Configuration EMPTY_CONFIGURATION = new Configuration(null);
    @JsonProperty
    private final Map<String, Object> source;
    @JsonIgnore
    private final Map<String, String> strings = Maps.newHashMap();
    @JsonIgnore
    private final Map<String, Integer> ints = Maps.newHashMap();
    @JsonIgnore
    private final Map<String, Boolean> bools = Maps.newHashMap();
    @JsonIgnore
    private final Map<String, List<String>> lists = Maps.newHashMap();

    @JsonCreator
    public Configuration(@JsonProperty(value="source") @Nullable Map<String, Object> m) {
        this.source = (Map)MoreObjects.firstNonNull(m, Collections.emptyMap());
        for (Map.Entry<String, Object> e : this.source.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            if (value == null) {
                LOG.debug("NULL value in configuration key <{}>", (Object)key);
                continue;
            }
            try {
                if (value instanceof String) {
                    this.strings.put(key, (String)value);
                    continue;
                }
                if (value instanceof Integer) {
                    this.ints.put(key, (Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    this.ints.put(key, ((Long)value).intValue());
                    continue;
                }
                if (value instanceof Double) {
                    this.ints.put(key, ((Double)value).intValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    this.bools.put(key, (Boolean)value);
                    continue;
                }
                if (value instanceof List) {
                    List list = ((List)value).stream().map(element -> (String)element).collect(Collectors.toList());
                    this.lists.put(key, list);
                    continue;
                }
                LOG.error("Cannot handle type [{}] of plugin configuration key <{}>.", (Object)value.getClass().getCanonicalName(), (Object)key);
            }
            catch (Exception ex) {
                LOG.warn("Could not read input configuration key <" + key + ">. Skipping.", (Throwable)ex);
            }
        }
    }

    @Nullable
    public String getString(String key) {
        return this.strings.get(key);
    }

    public String getString(String key, String defaultValue) {
        return (String)MoreObjects.firstNonNull((Object)this.strings.get(key), (Object)defaultValue);
    }

    public void setString(String key, String value) {
        this.strings.put(key, value);
    }

    public int getInt(String key) {
        return this.ints.get(key);
    }

    public int getInt(String key, int defaultValue) {
        return (Integer)MoreObjects.firstNonNull((Object)this.ints.get(key), (Object)defaultValue);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return (Boolean)MoreObjects.firstNonNull((Object)this.bools.get(key), (Object)defaultValue);
    }

    public boolean booleanIsSet(String key) {
        return this.bools.containsKey(key);
    }

    public void setBoolean(String key, boolean value) {
        this.bools.put(key, value);
    }

    public List<String> getList(String key) {
        return this.lists.get(key);
    }

    public List<String> getList(String key, List<String> defaultValue) {
        return (List)MoreObjects.firstNonNull(this.lists.get(key), defaultValue);
    }

    @Nullable
    public Map<String, Object> getSource() {
        return this.source;
    }

    public boolean stringIsSet(String key) {
        return !Strings.isNullOrEmpty((String)this.strings.get(key));
    }

    public boolean intIsSet(String key) {
        return this.ints.containsKey(key);
    }

    @Nullable
    public String serializeToJson() {
        try {
            return this.source.isEmpty() ? null : objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Serializing configuration failed.", (Throwable)e);
            return null;
        }
    }

    public static Configuration deserializeFromJson(String json) {
        if (Strings.isNullOrEmpty((String)json)) {
            return EMPTY_CONFIGURATION;
        }
        try {
            return (Configuration)objectMapper.readValue(json, Configuration.class);
        }
        catch (IOException e) {
            LOG.error("Deserializing configuration failed.", (Throwable)e);
            return EMPTY_CONFIGURATION;
        }
    }
}

