/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.configuration.fields;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog2.plugin.configuration.fields.AbstractConfigurationField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;

public class ListField
extends AbstractConfigurationField {
    public static final String FIELD_TYPE = "list";
    private List<String> defaultValue;
    private Map<String, String> values;
    private List<String> attributes;

    public ListField(String name, String humanName, List<String> defaultValue, String description, ConfigurationField.Optional isOptional) {
        this(name, humanName, defaultValue, Collections.emptyMap(), description, isOptional, null);
    }

    public ListField(String name, String humanName, List<String> defaultValue, Map<String, String> values, String description, ConfigurationField.Optional isOptional) {
        this(name, humanName, defaultValue, values, description, isOptional, null);
    }

    public ListField(String name, String humanName, List<String> defaultValue, Map<String, String> values, String description, ConfigurationField.Optional isOptional, Attribute ... attributes) {
        super(FIELD_TYPE, name, humanName, description, isOptional);
        this.defaultValue = defaultValue;
        this.values = values;
        this.attributes = new ArrayList<String>();
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                this.attributes.add(attribute.toString().toLowerCase(Locale.ENGLISH));
            }
        }
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        if (defaultValue instanceof List) {
            List defaultValueList = (List)defaultValue;
            this.defaultValue = defaultValueList.stream().filter(o -> o instanceof String).map(String::valueOf).collect(Collectors.toList());
        }
    }

    @Override
    public Map<String, Map<String, String>> getAdditionalInformation() {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        result.put("values", this.values);
        return result;
    }

    @Override
    public List<String> getAttributes() {
        return this.attributes;
    }

    public static enum Attribute {
        ALLOW_CREATE;

    }
}

