/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest;

import com.floreysoft.jmte.Engine;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;
import org.glassfish.grizzly.http.server.ErrorPageGenerator;
import org.glassfish.grizzly.http.server.Request;

public class GraylogErrorPageGenerator
implements ErrorPageGenerator {
    private final String template;
    private final Engine engine;

    public GraylogErrorPageGenerator() throws IOException {
        this(Resources.toString((URL)Resources.getResource((String)"error.html.template"), (Charset)StandardCharsets.UTF_8), new Engine());
    }

    public GraylogErrorPageGenerator(String template, Engine engine) {
        this.template = Objects.requireNonNull(template);
        this.engine = Objects.requireNonNull(engine);
    }

    public String generate(Request request, int status, String reasonPhrase, String description, Throwable exception) {
        ImmutableMap.Builder modelBuilder = ImmutableMap.builder();
        modelBuilder.put((Object)"reason", (Object)StringEscapeUtils.escapeHtml4((String)reasonPhrase));
        if (description != null) {
            modelBuilder.put((Object)"description", (Object)StringEscapeUtils.escapeHtml4((String)description));
        }
        if (exception != null) {
            String stacktrace = "";
            try (StringWriter stringWriter = new StringWriter();
                 PrintWriter printWriter = new PrintWriter(stringWriter);){
                exception.printStackTrace(printWriter);
                printWriter.flush();
                stringWriter.flush();
                stacktrace = stringWriter.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            modelBuilder.put((Object)"exception", (Object)StringEscapeUtils.escapeHtml4((String)exception.getMessage())).put((Object)"stacktrace", (Object)StringEscapeUtils.escapeHtml4((String)stacktrace));
        }
        return this.engine.transform(this.template, (Map)modelBuilder.build());
    }
}

