/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.metrics.requests.MetricsReadRequest;
import org.graylog2.rest.models.system.metrics.responses.MetricNamesResponse;
import org.graylog2.rest.models.system.metrics.responses.MetricsSummaryResponse;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.graylog2.shared.rest.resources.system.RemoteMetricsResource;
import retrofit2.Response;

@RequiresAuthentication
@Api(value="Cluster/Node/Metrics", description="Cluster-wide Internal Graylog node metrics")
@Path(value="/cluster/{nodeId}/metrics")
@Produces(value={"application/json"})
public class ClusterNodeMetricsResource
extends ProxiedResource {
    @Inject
    public ClusterNodeMetricsResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    private RemoteMetricsResource getResourceForNode(String nodeId) throws NodeNotFoundException {
        Node targetNode = this.nodeService.byNodeId(nodeId);
        return this.remoteInterfaceProvider.get(targetNode, this.authenticationToken, RemoteMetricsResource.class);
    }

    @GET
    @Timed
    @Path(value="/names")
    @ApiOperation(value="Get all metrics keys/names from node")
    @RequiresPermissions(value={"metrics:allkeys"})
    public MetricNamesResponse metricNames(@ApiParam(name="nodeId", value="The id of the node whose metrics we want.", required=true) @PathParam(value="nodeId") String nodeId) throws IOException, NodeNotFoundException {
        Response result = this.getResourceForNode(nodeId).metricNames().execute();
        if (result.isSuccessful()) {
            return (MetricNamesResponse)result.body();
        }
        throw new WebApplicationException(result.message(), Response.Status.BAD_GATEWAY);
    }

    @POST
    @Timed
    @Path(value="/multiple")
    @ApiOperation(value="Get the values of multiple metrics at once from node")
    @ApiResponses(value={@ApiResponse(code=400, message="Malformed body")})
    @NoAuditEvent(value="only used to get multiple metric values")
    public MetricsSummaryResponse multipleMetrics(@ApiParam(name="nodeId", value="The id of the node whose metrics we want.", required=true) @PathParam(value="nodeId") String nodeId, @ApiParam(name="Requested metrics", required=true) @Valid @NotNull MetricsReadRequest request) throws IOException, NodeNotFoundException {
        Response result = this.getResourceForNode(nodeId).multipleMetrics(request).execute();
        if (result.isSuccessful()) {
            return (MetricsSummaryResponse)result.body();
        }
        throw new WebApplicationException(result.message(), Response.Status.BAD_GATEWAY);
    }

    @GET
    @Timed
    @Path(value="/namespace/{namespace}")
    @ApiOperation(value="Get all metrics of a namespace from node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such metric namespace")})
    public MetricsSummaryResponse byNamespace(@ApiParam(name="nodeId", value="The id of the node whose metrics we want.", required=true) @PathParam(value="nodeId") String nodeId, @ApiParam(name="namespace", required=true) @PathParam(value="namespace") String namespace) throws IOException, NodeNotFoundException {
        Response result = this.getResourceForNode(nodeId).byNamespace(namespace).execute();
        if (result.isSuccessful()) {
            return (MetricsSummaryResponse)result.body();
        }
        throw new WebApplicationException(result.message(), Response.Status.BAD_GATEWAY);
    }
}

