/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.alerts;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.alerts.AlertService;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.configuration.ConfigurableTypeInfo;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.streams.alerts.AlertConditionListSummary;
import org.graylog2.rest.models.streams.alerts.AlertConditionSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;

@RequiresAuthentication
@Api(value="AlertConditions", description="Manage stream alert conditions")
@Path(value="/alerts/conditions")
@Produces(value={"application/json"})
public class AlertConditionsResource
extends RestResource {
    private final Map<String, AlertCondition.Factory> alertConditionTypesMap;
    private final StreamService streamService;
    private final AlertService alertService;

    @Inject
    public AlertConditionsResource(Map<String, AlertCondition.Factory> alertConditionTypesMap, StreamService streamService, AlertService alertService) {
        this.alertConditionTypesMap = alertConditionTypesMap;
        this.streamService = streamService;
        this.alertService = alertService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all alert conditions")
    public AlertConditionListSummary all() {
        List<Stream> streams = this.streamService.loadAll();
        List<AlertConditionSummary> conditionSummaries = streams.stream().filter(stream -> this.isPermitted("streams:read", stream.getId())).flatMap(stream -> this.streamService.getAlertConditions((Stream)stream).stream().map(condition -> AlertConditionSummary.create(condition.getId(), condition.getType(), condition.getCreatorUserId(), condition.getCreatedAt().toDate(), condition.getParameters(), this.alertService.inGracePeriod((AlertCondition)condition), condition.getTitle()))).collect(Collectors.toList());
        return AlertConditionListSummary.create(conditionSummaries);
    }

    @GET
    @Path(value="/types")
    @Timed
    @ApiOperation(value="Get a list of all alert condition types")
    public Map<String, ConfigurableTypeInfo> available() {
        return this.alertConditionTypesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ConfigurableTypeInfo.create((String)entry.getKey(), ((AlertCondition.Factory)entry.getValue()).descriptor(), ((AlertCondition.Factory)entry.getValue()).config().getRequestedConfiguration())));
    }
}

